/*
 * Decompiled with CFR 0.152.
 */
package com.fincatto.documentofiscal.mdfe3.classes.nota;

import com.fincatto.documentofiscal.mdfe3.classes.nota.MDFInfoInformacoesCTe;
import com.fincatto.documentofiscal.mdfe3.classes.nota.MDFInfoInformacoesMDFe;
import com.fincatto.documentofiscal.mdfe3.classes.nota.MDFInfoInformacoesNFe;
import com.fincatto.documentofiscal.validadores.DFListValidador;
import com.fincatto.documentofiscal.validadores.DFStringValidador;
import java.util.List;
import org.simpleframework.xml.Element;
import org.simpleframework.xml.ElementList;

public class MDFInfoInformacoesMunicipioDescarga {
    @Element(name="cMunDescarga")
    private String municipioDescarga;
    @Element(name="xMunDescarga")
    private String xMunDescarga;
    @ElementList(entry="infCTe", inline=true, required=false)
    private List<MDFInfoInformacoesCTe> infCTe;
    @ElementList(entry="infNFe", inline=true, required=false)
    private List<MDFInfoInformacoesNFe> infNFe;
    @ElementList(entry="infMDFeTransp", inline=true, required=false)
    private List<MDFInfoInformacoesMDFe> infMDFeTransp;

    public String getMunicipioDescarga() {
        return this.municipioDescarga;
    }

    public void setMunicipioDescarga(String municipioDescarga) {
        this.municipioDescarga = DFStringValidador.validaIntervalo(municipioDescarga, 7, 7, "codigo municipio descarga", true);
    }

    public String getxMunDescarga() {
        return this.xMunDescarga;
    }

    public void setxMunDescarga(String xMunDescarga) {
        this.xMunDescarga = DFStringValidador.validaIntervalo(xMunDescarga, 2, 60, "Nome do Munic\u00edpio de Descarregamento");
    }

    public List<MDFInfoInformacoesCTe> getInfCTe() {
        return this.infCTe;
    }

    public void setInfCTe(List<MDFInfoInformacoesCTe> infCTe) {
        this.infCTe = DFListValidador.validaListaNaoObrigatoria(infCTe, 10000, "Conhecimentos de Tranporte em MDF-e");
    }

    public List<MDFInfoInformacoesNFe> getInfNFe() {
        return this.infNFe;
    }

    public void setInfNFe(List<MDFInfoInformacoesNFe> infNFe) {
        this.infNFe = DFListValidador.validaListaNaoObrigatoria(infNFe, 10000, "Notas fiscais em MDF-e");
    }

    public List<MDFInfoInformacoesMDFe> getInfMDFeTransp() {
        return this.infMDFeTransp;
    }

    public void setInfMDFeTransp(List<MDFInfoInformacoesMDFe> infMDFeTransp) {
        this.infMDFeTransp = DFListValidador.validaListaNaoObrigatoria(infMDFeTransp, 10000, "Manifesto Eletr\u00f4nico de Documentos Fiscais em MDF-e");
    }
}

