/*
 * Decompiled with CFR 0.152.
 */
package com.fincatto.documentofiscal.mdfe3.classes.nota;

import com.fincatto.documentofiscal.DFBase;
import com.fincatto.documentofiscal.validadores.DFBigDecimalValidador;
import com.fincatto.documentofiscal.validadores.DFStringValidador;
import java.math.BigDecimal;
import org.simpleframework.xml.Element;

public class MDFInfoModalRodoviarioPedagioDisp
extends DFBase {
    private static final long serialVersionUID = 2437667548944630950L;
    @Element(name="CNPJForn")
    private String cnpjFornecedora;
    @Element(name="CNPJPg", required=false)
    private String cnpjPagadora;
    @Element(name="CPFPg")
    protected String cpfPagadora;
    @Element(name="nCompra")
    private String numeroComprovante;
    @Element(name="vValePed")
    private String valor;

    public String getCnpjFornecedora() {
        return this.cnpjFornecedora;
    }

    public void setCnpjFornecedora(String cnpjFornecedora) {
        DFStringValidador.cnpj(cnpjFornecedora);
        this.cnpjFornecedora = cnpjFornecedora;
    }

    public String getNumeroComprovante() {
        return this.numeroComprovante;
    }

    public void setNumeroComprovante(String numeroComprovante) {
        DFStringValidador.tamanho20N(numeroComprovante, "Numero do comprovante de compra");
        this.numeroComprovante = numeroComprovante;
    }

    public String getCnpjPagadora() {
        return this.cnpjPagadora;
    }

    public void setCnpjPagadora(String cnpjPagadora) {
        if (this.cpfPagadora != null) {
            throw new IllegalStateException("Nao deve setar CNPJ se CPF esteja setado em PedagioDisp ");
        }
        DFStringValidador.cnpj(cnpjPagadora);
        this.cnpjPagadora = cnpjPagadora;
    }

    public String getValor() {
        return this.valor;
    }

    public void setValor(BigDecimal valor) {
        this.valor = DFBigDecimalValidador.tamanho13Com2CasasDecimais(valor, "Valor do pedagio");
    }

    public String getCpfPagadora() {
        return this.cpfPagadora;
    }

    public void setCpfPagadora(String cpfPagadora) {
        if (this.cnpjPagadora != null) {
            throw new IllegalStateException("Nao deve setar CPF se CNPJ esteja setado em PedagioDisp ");
        }
        DFStringValidador.cpf(cpfPagadora);
        this.cpfPagadora = cpfPagadora;
    }
}

