/*
 * Decompiled with CFR 0.152.
 */
package com.fincatto.documentofiscal.mdfe3.classes.nota;

import com.fincatto.documentofiscal.validadores.DFStringValidador;
import org.apache.commons.lang3.StringUtils;
import org.simpleframework.xml.Element;

public class MDFInfoPerigosos {
    @Element(name="nONU")
    private String numeroONU;
    @Element(name="xNomeAE", required=false)
    private String nomeEmbarque;
    @Element(name="xClaRisco", required=false)
    private String classeRisco;
    @Element(name="grEmb", required=false)
    private String grupoEmbalagem;
    @Element(name="qTotProd")
    private String qTotProd;
    @Element(name="qVolTipo", required=false)
    private String qtdeTipoVolume;

    public String getNumeroONU() {
        return this.numeroONU;
    }

    public void setNumeroONU(String numeroONU) {
        if (StringUtils.isNumeric((CharSequence)numeroONU)) {
            DFStringValidador.validaIntervalo(numeroONU, 4, 4, "numero ONU em produtos perigosos", true);
        } else {
            DFStringValidador.equals("ND", numeroONU);
        }
        this.numeroONU = numeroONU;
    }

    public String getNomeEmbarque() {
        return this.nomeEmbarque;
    }

    public void setNomeEmbarque(String nomeEmbarque) {
        this.nomeEmbarque = DFStringValidador.validaIntervalo(nomeEmbarque, 1, 150, "Nome Embarque produtos perigosos");
    }

    public String getClasseRisco() {
        return this.classeRisco;
    }

    public void setClasseRisco(String classeRisco) {
        this.classeRisco = DFStringValidador.validaIntervalo(classeRisco, 1, 40, "Classifica\u00e7\u00e3o de risco em produtos perigosos");
    }

    public String getGrupoEmbalagem() {
        return this.grupoEmbalagem;
    }

    public void setGrupoEmbalagem(String grupoEmbalagem) {
        this.grupoEmbalagem = DFStringValidador.validaIntervalo(grupoEmbalagem, 1, 40, "Grupo embalagem em produtos perigosos");
    }

    public String getqTotProd() {
        return this.qTotProd;
    }

    public void setqTotProd(String qTotProd) {
        this.qTotProd = DFStringValidador.validaIntervalo(qTotProd, 1, 20, "Qtde Total em produtos perigosos");
    }

    public String getQtdeTipoVolume() {
        return this.qtdeTipoVolume;
    }

    public void setQtdeTipoVolume(String qtdeTipoVolume) {
        this.qtdeTipoVolume = DFStringValidador.validaIntervalo(qtdeTipoVolume, 1, 60, "Qtde Tipo Volume em produtos perigosos");
    }
}

