/*
 * Decompiled with CFR 0.152.
 */
package com.fincatto.documentofiscal.mdfe3.classes.nota.evento;

import com.fincatto.documentofiscal.DFAmbiente;
import com.fincatto.documentofiscal.DFBase;
import com.fincatto.documentofiscal.mdfe3.classes.nota.evento.MDFeDetalhamentoEvento;
import com.fincatto.documentofiscal.validadores.DFBigDecimalValidador;
import com.fincatto.documentofiscal.validadores.DFIntegerValidador;
import com.fincatto.documentofiscal.validadores.DFStringValidador;
import java.math.BigDecimal;
import java.time.ZonedDateTime;
import org.simpleframework.xml.Attribute;
import org.simpleframework.xml.Element;
import org.simpleframework.xml.Root;

@Root(name="infEvento")
public class MDFeInfoEvento
extends DFBase {
    private static final long serialVersionUID = -9002694768514200146L;
    @Attribute(name="Id", required=false)
    private String id;
    @Element(name="cOrgao", required=false)
    private String orgao;
    @Element(name="tpAmb")
    private DFAmbiente ambiente;
    @Element(name="CNPJ", required=false)
    private String cnpj;
    @Element(name="chMDFe")
    private String chave;
    @Element(name="dhEvento")
    private ZonedDateTime dataHoraEvento;
    @Element(name="tpEvento")
    private String codigoEvento;
    @Element(name="nSeqEvento")
    private Integer numeroSequencialEvento;
    @Element(name="verEvento", required=false)
    private String versaoEvento;
    @Element(name="detEvento")
    private MDFeDetalhamentoEvento detEvento;

    public void setOrgao(String orgao) {
        this.orgao = orgao;
    }

    public void setVersaoEvento(BigDecimal versaoEvento) {
        this.versaoEvento = DFBigDecimalValidador.tamanho5Com2CasasDecimais(versaoEvento, "Versao do Evento");
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        DFStringValidador.exatamente54(id, "Info Evento  ID");
        this.id = id;
    }

    public DFAmbiente getAmbiente() {
        return this.ambiente;
    }

    public void setAmbiente(DFAmbiente ambiente) {
        this.ambiente = ambiente;
    }

    public String getCnpj() {
        return this.cnpj;
    }

    public void setCnpj(String cnpj) {
        DFStringValidador.cnpj(cnpj);
        this.cnpj = cnpj;
    }

    public String getChave() {
        return this.chave;
    }

    public void setChave(String chave) {
        DFStringValidador.exatamente44N(chave, "Info Evento Cancelamento Chave");
        this.chave = chave;
    }

    public ZonedDateTime getDataHoraEvento() {
        return this.dataHoraEvento;
    }

    public void setDataHoraEvento(ZonedDateTime dataHoraEvento) {
        this.dataHoraEvento = dataHoraEvento;
    }

    public String getCodigoEvento() {
        return this.codigoEvento;
    }

    public void setCodigoEvento(String codigoEvento) {
        DFStringValidador.exatamente6N(codigoEvento, "Info Evento Cancelamento Codigo");
        this.codigoEvento = codigoEvento;
    }

    public int getNumeroSequencialEvento() {
        return this.numeroSequencialEvento;
    }

    public void setNumeroSequencialEvento(int numeroSequencialEvento) {
        DFIntegerValidador.tamanho1a2(numeroSequencialEvento, "Numero Sequencial Evento");
        this.numeroSequencialEvento = numeroSequencialEvento;
    }

    public String getVersaoEvento() {
        return this.versaoEvento;
    }

    public String getOrgao() {
        return this.orgao;
    }

    public void setNumeroSequencialEvento(Integer numeroSequencialEvento) {
        this.numeroSequencialEvento = numeroSequencialEvento;
    }

    public void setVersaoEvento(String versaoEvento) {
        this.versaoEvento = versaoEvento;
    }

    public MDFeDetalhamentoEvento getDetEvento() {
        return this.detEvento;
    }

    public void setDetEvento(MDFeDetalhamentoEvento detEvento) {
        this.detEvento = detEvento;
    }
}

