/*
 * Decompiled with CFR 0.152.
 */
package com.fincatto.documentofiscal.mdfe3.utils;

import com.fincatto.documentofiscal.mdfe3.MDFeConfig;
import com.fincatto.documentofiscal.mdfe3.classes.def.MDFTipoEmissao;
import com.fincatto.documentofiscal.mdfe3.classes.nota.MDFe;
import com.fincatto.documentofiscal.utils.DFAssinaturaDigital;

public class MDFGeraQRCode {
    private final MDFe mdf;
    private final MDFeConfig config;
    private static String qrCodeUrl = "https://dfe-portal.svrs.rs.gov.br/mdfe/qrCode";

    public MDFGeraQRCode(MDFe nota, MDFeConfig config) {
        this.mdf = nota;
        this.config = config;
    }

    public String getQRCode() throws Exception {
        StringBuilder parametros = new StringBuilder();
        String url = qrCodeUrl;
        String chaveAcesso = this.mdf.getInfo().getChaveAcesso();
        parametros.append("chMDFe=").append(chaveAcesso).append("&");
        parametros.append("tpAmb=").append(this.config.getAmbiente().getCodigo());
        if (this.config.getTipoEmissao().equals((Object)MDFTipoEmissao.CONTINGENCIA)) {
            parametros.append("&sign=").append(new DFAssinaturaDigital(this.config).assinarString(chaveAcesso));
        }
        return url + "?" + parametros.toString();
    }

    public String urlConsultaChaveAcesso() {
        return "https://dfe-portal.svrs.rs.gov.br/MDFe/consulta";
    }
}

