/*
 * Decompiled with CFR 0.152.
 */
package com.fincatto.documentofiscal.mdfe3.webservices;

import com.fincatto.documentofiscal.DFLog;
import com.fincatto.documentofiscal.mdfe3.MDFeConfig;
import com.fincatto.documentofiscal.mdfe3.classes.MDFAutorizador3;
import com.fincatto.documentofiscal.mdfe3.classes.consultanaoencerrados.MDFeConsultaNaoEncerrados;
import com.fincatto.documentofiscal.mdfe3.classes.consultanaoencerrados.MDFeConsultaNaoEncerradosRetorno;
import com.fincatto.documentofiscal.mdfe3.webservices.consultanaoencerrado.MDFeConsNaoEncStub;
import java.rmi.RemoteException;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.util.AXIOMUtil;

class WSConsultaNaoEncerrados
implements DFLog {
    private static final String NOME_SERVICO = "CONSULTAR N\u00c3O ENCERRADOS";
    private final MDFeConfig config;

    WSConsultaNaoEncerrados(MDFeConfig config) {
        this.config = config;
    }

    MDFeConsultaNaoEncerradosRetorno consultaNaoEncerrados(String cnpj) throws Exception {
        OMElement omElementConsulta = AXIOMUtil.stringToOM((String)this.gerarDadosConsulta(cnpj).toString());
        this.getLogger().debug(omElementConsulta.toString());
        OMElement omElementResult = this.efetuaConsultaStatus(omElementConsulta);
        this.getLogger().debug(omElementResult.toString());
        return (MDFeConsultaNaoEncerradosRetorno)this.config.getPersister().read(MDFeConsultaNaoEncerradosRetorno.class, omElementResult.toString());
    }

    private MDFeConsultaNaoEncerrados gerarDadosConsulta(String cnpj) {
        MDFeConsultaNaoEncerrados encerrados = new MDFeConsultaNaoEncerrados();
        encerrados.setAmbiente(this.config.getAmbiente());
        encerrados.setVersao("3.00");
        encerrados.setCnpj(cnpj);
        encerrados.setServico(NOME_SERVICO);
        return encerrados;
    }

    private OMElement efetuaConsultaStatus(OMElement omElement) throws RemoteException {
        MDFeConsNaoEncStub.MdfeCabecMsg cabec = new MDFeConsNaoEncStub.MdfeCabecMsg();
        cabec.setCUF(this.config.getCUF().getCodigoIbge());
        cabec.setVersaoDados("3.00");
        MDFeConsNaoEncStub.MdfeCabecMsgE cabecEnv = new MDFeConsNaoEncStub.MdfeCabecMsgE();
        cabecEnv.setMdfeCabecMsg(cabec);
        MDFeConsNaoEncStub.MdfeDadosMsg dados = new MDFeConsNaoEncStub.MdfeDadosMsg();
        dados.setExtraElement(omElement);
        MDFAutorizador3 autorizador = MDFAutorizador3.valueOfCodigoUF(this.config.getCUF());
        String endpoint = autorizador.getMDFeConsNaoEnc(this.config.getAmbiente());
        if (endpoint == null) {
            throw new IllegalArgumentException("Nao foi possivel encontrar URL para CONSULTAR NAO ENCERRADOS, autorizador " + autorizador.name() + ", UF " + this.config.getCUF().name());
        }
        this.getLogger().debug(endpoint);
        MDFeConsNaoEncStub.MdfeConsNaoEncResult result = new MDFeConsNaoEncStub(endpoint, this.config).mdfeConsNaoEnc(dados, cabecEnv);
        return result.getExtraElement();
    }
}

