/*
 * Decompiled with CFR 0.152.
 */
package com.fincatto.documentofiscal.mdfe3.webservices;

import com.fincatto.documentofiscal.DFLog;
import com.fincatto.documentofiscal.mdfe3.MDFeConfig;
import com.fincatto.documentofiscal.mdfe3.classes.MDFAutorizador3;
import com.fincatto.documentofiscal.mdfe3.classes.consultaRecibo.MDFeConsultaRecibo;
import com.fincatto.documentofiscal.mdfe3.classes.consultaRecibo.MDFeConsultaReciboRetorno;
import com.fincatto.documentofiscal.mdfe3.webservices.retornorecepcao.MDFeRetRecepcaoStub;
import java.rmi.RemoteException;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.util.AXIOMUtil;

class WSConsultaRecibo
implements DFLog {
    private final MDFeConfig config;

    WSConsultaRecibo(MDFeConfig config) {
        this.config = config;
    }

    MDFeConsultaReciboRetorno consultaRecibo(String numeroRecibo) throws Exception {
        OMElement omElementConsulta = AXIOMUtil.stringToOM((String)this.gerarDadosConsulta(numeroRecibo).toString());
        this.getLogger().debug(omElementConsulta.toString());
        OMElement omElementResult = this.efetuaConsultaRecibo(omElementConsulta);
        this.getLogger().debug(omElementResult.toString());
        return (MDFeConsultaReciboRetorno)this.config.getPersister().read(MDFeConsultaReciboRetorno.class, omElementResult.toString());
    }

    private MDFeConsultaRecibo gerarDadosConsulta(String numeroRecibo) {
        MDFeConsultaRecibo consultaRecibo = new MDFeConsultaRecibo();
        consultaRecibo.setNumeroRecibo(numeroRecibo);
        consultaRecibo.setAmbiente(this.config.getAmbiente());
        consultaRecibo.setVersao("3.00");
        return consultaRecibo;
    }

    private OMElement efetuaConsultaRecibo(OMElement omElement) throws RemoteException {
        MDFeRetRecepcaoStub.MdfeCabecMsg cabec = new MDFeRetRecepcaoStub.MdfeCabecMsg();
        cabec.setCUF(this.config.getCUF().getCodigoIbge());
        cabec.setVersaoDados("3.00");
        MDFeRetRecepcaoStub.MdfeCabecMsgE cabecEnv = new MDFeRetRecepcaoStub.MdfeCabecMsgE();
        cabecEnv.setMdfeCabecMsg(cabec);
        MDFeRetRecepcaoStub.MdfeDadosMsg dados = new MDFeRetRecepcaoStub.MdfeDadosMsg();
        dados.setExtraElement(omElement);
        MDFAutorizador3 autorizador = MDFAutorizador3.valueOfCodigoUF(this.config.getCUF());
        String endpoint = autorizador.getMDFeRetornoRecepcao(this.config.getAmbiente());
        if (endpoint == null) {
            throw new IllegalArgumentException("Nao foi possivel encontrar URL para Consulta Recibo, autorizador " + autorizador.name() + ", UF " + this.config.getCUF().name());
        }
        return new MDFeRetRecepcaoStub(endpoint, this.config).mdfeRetRecepcao(dados, cabecEnv).getExtraElement();
    }
}

