/*
 * Decompiled with CFR 0.152.
 */
package com.fincatto.documentofiscal.mdfe3.webservices;

import com.fincatto.documentofiscal.DFUnidadeFederativa;
import com.fincatto.documentofiscal.mdfe3.MDFeConfig;
import com.fincatto.documentofiscal.mdfe3.classes.consultaRecibo.MDFeConsultaReciboRetorno;
import com.fincatto.documentofiscal.mdfe3.classes.consultanaoencerrados.MDFeConsultaNaoEncerradosRetorno;
import com.fincatto.documentofiscal.mdfe3.classes.consultastatusservico.MDFeConsStatServRet;
import com.fincatto.documentofiscal.mdfe3.classes.lote.envio.MDFEnvioLote;
import com.fincatto.documentofiscal.mdfe3.classes.lote.envio.MDFEnvioLoteRetornoDados;
import com.fincatto.documentofiscal.mdfe3.classes.nota.MDFInfoModalRodoviarioInfPag;
import com.fincatto.documentofiscal.mdfe3.classes.nota.MDFInfoModalRodoviarioInfViagens;
import com.fincatto.documentofiscal.mdfe3.classes.nota.consulta.MDFeNotaConsultaRetorno;
import com.fincatto.documentofiscal.mdfe3.classes.nota.evento.MDFeEnviaEventoIncluirDFeInfDoc;
import com.fincatto.documentofiscal.mdfe3.classes.nota.evento.MDFeRetorno;
import com.fincatto.documentofiscal.mdfe3.webservices.WSCancelamento;
import com.fincatto.documentofiscal.mdfe3.webservices.WSConsultaNaoEncerrados;
import com.fincatto.documentofiscal.mdfe3.webservices.WSConsultaRecibo;
import com.fincatto.documentofiscal.mdfe3.webservices.WSEncerramento;
import com.fincatto.documentofiscal.mdfe3.webservices.WSIncluirCondutor;
import com.fincatto.documentofiscal.mdfe3.webservices.WSIncluirDFe;
import com.fincatto.documentofiscal.mdfe3.webservices.WSNotaConsulta;
import com.fincatto.documentofiscal.mdfe3.webservices.WSPagamentoTransporte;
import com.fincatto.documentofiscal.mdfe3.webservices.WSRecepcaoLote;
import com.fincatto.documentofiscal.mdfe3.webservices.WSStatusConsulta;
import com.fincatto.documentofiscal.utils.DFSocketFactory;
import java.io.IOException;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.time.LocalDate;
import java.util.List;
import org.apache.commons.httpclient.protocol.Protocol;
import org.apache.commons.httpclient.protocol.ProtocolSocketFactory;

public class WSFacade {
    private final WSStatusConsulta wsStatusConsulta;
    private final WSRecepcaoLote wsRecepcaoLote;
    private final WSNotaConsulta wsNotaConsulta;
    private final WSCancelamento wsCancelamento;
    private final WSEncerramento wsEncerramento;
    private final WSConsultaRecibo wsConsultaRecibo;
    private final WSConsultaNaoEncerrados wsConsultaNaoEncerrados;
    private final WSIncluirCondutor wsIncluirCondutor;
    private final WSIncluirDFe wsIncluirDFe;
    private final WSPagamentoTransporte wsPagamentoTransporte;

    public WSFacade(MDFeConfig config) throws IOException, KeyManagementException, UnrecoverableKeyException, KeyStoreException, NoSuchAlgorithmException, CertificateException {
        Protocol.registerProtocol((String)"https", (Protocol)new Protocol("https", (ProtocolSocketFactory)new DFSocketFactory(config), 443));
        this.wsStatusConsulta = new WSStatusConsulta(config);
        this.wsRecepcaoLote = new WSRecepcaoLote(config);
        this.wsNotaConsulta = new WSNotaConsulta(config);
        this.wsCancelamento = new WSCancelamento(config);
        this.wsEncerramento = new WSEncerramento(config);
        this.wsConsultaRecibo = new WSConsultaRecibo(config);
        this.wsConsultaNaoEncerrados = new WSConsultaNaoEncerrados(config);
        this.wsIncluirCondutor = new WSIncluirCondutor(config);
        this.wsIncluirDFe = new WSIncluirDFe(config);
        this.wsPagamentoTransporte = new WSPagamentoTransporte(config);
    }

    public MDFEnvioLoteRetornoDados envioRecepcaoLote(MDFEnvioLote mdfEnvioLote) throws Exception {
        return this.wsRecepcaoLote.envioRecepcao(mdfEnvioLote);
    }

    public MDFeConsStatServRet consultaStatus(DFUnidadeFederativa uf) throws Exception {
        return this.wsStatusConsulta.consultaStatus(uf);
    }

    public MDFeConsStatServRet consultaStatus() throws Exception {
        return this.wsStatusConsulta.consultaStatus(DFUnidadeFederativa.RS);
    }

    public MDFeNotaConsultaRetorno consultaMdfe(String chaveDeAcesso) throws Exception {
        return this.wsNotaConsulta.consultaNota(chaveDeAcesso);
    }

    public MDFeRetorno cancelaMdfe(String chave, String numeroProtocolo, String motivo) throws Exception {
        return this.wsCancelamento.cancelaNota(chave, numeroProtocolo, motivo);
    }

    public MDFeRetorno cancelaMdfeAssinado(String chave, String eventoAssinadoXml) throws Exception {
        return this.wsCancelamento.cancelaNotaAssinada(chave, eventoAssinadoXml);
    }

    public MDFeRetorno encerramento(String chaveAcesso, String numeroProtocolo, String codigoMunicipio, LocalDate dataEncerramento, DFUnidadeFederativa unidadeFederativa) throws Exception {
        return this.wsEncerramento.encerraMdfe(chaveAcesso, numeroProtocolo, codigoMunicipio, dataEncerramento, unidadeFederativa);
    }

    public MDFeRetorno encerramentoAssinado(String chaveAcesso, String eventoAssinadoXml) throws Exception {
        return this.wsEncerramento.encerramentoMdfeAssinado(chaveAcesso, eventoAssinadoXml);
    }

    public MDFeConsultaReciboRetorno consultaRecibo(String numeroRecibo) throws Exception {
        return this.wsConsultaRecibo.consultaRecibo(numeroRecibo);
    }

    public MDFeConsultaNaoEncerradosRetorno consultaNaoEncerrados(String cnpj) throws Exception {
        return this.wsConsultaNaoEncerrados.consultaNaoEncerrados(cnpj);
    }

    public MDFeRetorno incluirCondutor(String chaveAcesso, String nomeCondutor, String cpfCondutor) throws Exception {
        return this.wsIncluirCondutor.incluirCondutor(chaveAcesso, nomeCondutor, cpfCondutor);
    }

    public MDFeRetorno incluirCondutorAssinado(String chaveAcesso, String eventoAssinadoXml) throws Exception {
        return this.wsIncluirCondutor.incluirCondutorAssinado(chaveAcesso, eventoAssinadoXml);
    }

    public MDFeRetorno incluirDFe(String chaveAcesso, String nProt, String cMunCarrega, String xMunCarrega, List<MDFeEnviaEventoIncluirDFeInfDoc> infDoc) throws Exception {
        return this.wsIncluirDFe.incluirDFe(chaveAcesso, nProt, cMunCarrega, xMunCarrega, infDoc);
    }

    public MDFeRetorno incluirDFeAssinado(String chaveAcesso, String eventoAssinadoXml) throws Exception {
        return this.wsIncluirDFe.incluirDFeAssinado(chaveAcesso, eventoAssinadoXml);
    }

    public MDFeRetorno pagamentoTransporte(String chaveAcesso, String nProt, List<MDFInfoModalRodoviarioInfPag> infPag, List<MDFInfoModalRodoviarioInfViagens> infViagens) throws Exception {
        return this.wsPagamentoTransporte.pagamento(chaveAcesso, nProt, infPag, infViagens);
    }

    public MDFeRetorno pagamentoTransporteAssinado(String chaveAcesso, String eventoAssinadoXml) throws Exception {
        return this.wsPagamentoTransporte.pagamentoAssinado(chaveAcesso, eventoAssinadoXml);
    }
}

