/*
 * Decompiled with CFR 0.152.
 */
package com.fincatto.documentofiscal.mdfe3.webservices;

import com.fincatto.documentofiscal.DFLog;
import com.fincatto.documentofiscal.mdfe3.MDFeConfig;
import com.fincatto.documentofiscal.mdfe3.classes.MDFAutorizador3;
import com.fincatto.documentofiscal.mdfe3.classes.nota.consulta.MDFeNotaConsulta;
import com.fincatto.documentofiscal.mdfe3.classes.nota.consulta.MDFeNotaConsultaRetorno;
import com.fincatto.documentofiscal.mdfe3.classes.parsers.MDFChaveParser;
import com.fincatto.documentofiscal.mdfe3.webservices.consulta.MDFeConsultaStub;
import java.math.BigDecimal;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.util.AXIOMUtil;

class WSNotaConsulta
implements DFLog {
    private static final String NOME_SERVICO = "CONSULTAR";
    private static final String VERSAO_SERVICO = "3.00";
    private final MDFeConfig config;

    WSNotaConsulta(MDFeConfig config) {
        this.config = config;
    }

    public MDFeNotaConsultaRetorno consultaNota(String chaveDeAcesso) throws Exception {
        OMElement omElementConsulta = AXIOMUtil.stringToOM((String)this.gerarDadosConsulta(chaveDeAcesso).toString());
        this.getLogger().debug(omElementConsulta.toString());
        OMElement omElementRetorno = this.efetuaConsulta(omElementConsulta, chaveDeAcesso);
        this.getLogger().debug(omElementRetorno.toString());
        return (MDFeNotaConsultaRetorno)this.config.getPersister().read(MDFeNotaConsultaRetorno.class, omElementRetorno.toString());
    }

    private OMElement efetuaConsulta(OMElement omElementConsulta, String chaveDeAcesso) throws Exception {
        MDFChaveParser ctChaveParser = new MDFChaveParser(chaveDeAcesso);
        MDFeConsultaStub.MdfeCabecMsg cabec = new MDFeConsultaStub.MdfeCabecMsg();
        cabec.setCUF(ctChaveParser.getNFUnidadeFederativa().getCodigoIbge());
        cabec.setVersaoDados(VERSAO_SERVICO);
        MDFeConsultaStub.MdfeCabecMsgE cabecE = new MDFeConsultaStub.MdfeCabecMsgE();
        cabecE.setMdfeCabecMsg(cabec);
        MDFeConsultaStub.MdfeDadosMsg dados = new MDFeConsultaStub.MdfeDadosMsg();
        dados.setExtraElement(omElementConsulta);
        MDFAutorizador3 autorizador = MDFAutorizador3.valueOfCodigoUF(this.config.getCUF());
        String endpoint = autorizador.getMDFeConsulta(this.config.getAmbiente());
        if (endpoint == null) {
            throw new IllegalArgumentException("Nao foi possivel encontrar URL para Consulta, autorizador " + autorizador.name() + ", UF " + this.config.getCUF().name());
        }
        MDFeConsultaStub.MdfeConsultaMDFResult mdfeConsultaMDFResult = new MDFeConsultaStub(endpoint, this.config).mdfeConsultaMDF(dados, cabecE);
        return mdfeConsultaMDFResult.getExtraElement();
    }

    private MDFeNotaConsulta gerarDadosConsulta(String chaveDeAcesso) {
        MDFeNotaConsulta notaConsulta = new MDFeNotaConsulta();
        notaConsulta.setAmbiente(this.config.getAmbiente());
        notaConsulta.setChave(chaveDeAcesso);
        notaConsulta.setServico(NOME_SERVICO);
        notaConsulta.setVersao(new BigDecimal(VERSAO_SERVICO));
        return notaConsulta;
    }
}

