/*
 * Decompiled with CFR 0.152.
 */
package com.fincatto.documentofiscal.mdfe3.webservices;

import com.fincatto.documentofiscal.DFLog;
import com.fincatto.documentofiscal.mdfe3.MDFeConfig;
import com.fincatto.documentofiscal.mdfe3.classes.MDFAutorizador3;
import com.fincatto.documentofiscal.mdfe3.classes.lote.envio.MDFEnvioLote;
import com.fincatto.documentofiscal.mdfe3.classes.lote.envio.MDFEnvioLoteRetorno;
import com.fincatto.documentofiscal.mdfe3.classes.lote.envio.MDFEnvioLoteRetornoDados;
import com.fincatto.documentofiscal.mdfe3.webservices.recepcao.MDFeRecepcaoStub;
import com.fincatto.documentofiscal.utils.DFAssinaturaDigital;
import com.fincatto.documentofiscal.validadores.DFXMLValidador;
import java.io.StringReader;
import java.util.Iterator;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.impl.builder.StAXOMBuilder;

class WSRecepcaoLote
implements DFLog {
    private static final String MDFE_ELEMENTO = "MDFe";
    private final MDFeConfig config;

    WSRecepcaoLote(MDFeConfig config) {
        this.config = config;
    }

    public MDFEnvioLoteRetornoDados envioRecepcao(MDFEnvioLote mdfeRecepcaoLote) throws Exception {
        String documentoAssinado = new DFAssinaturaDigital(this.config).assinarDocumento(mdfeRecepcaoLote.toString(), "infMDFe");
        MDFEnvioLote loteAssinado = (MDFEnvioLote)this.config.getPersister().read(MDFEnvioLote.class, documentoAssinado);
        MDFEnvioLoteRetorno retorno = this.comunicaLote(documentoAssinado);
        return new MDFEnvioLoteRetornoDados(retorno, loteAssinado);
    }

    private MDFEnvioLoteRetorno comunicaLote(String loteAssinadoXml) throws Exception {
        System.setProperty("jdk.xml.maxOccurLimit", "10000");
        DFXMLValidador.validaLoteMDFe(loteAssinadoXml);
        OMElement omElement = this.mdfeToOMElement(loteAssinadoXml);
        MDFeRecepcaoStub.MdfeDadosMsg dados = new MDFeRecepcaoStub.MdfeDadosMsg();
        dados.setExtraElement(omElement);
        MDFeRecepcaoStub.MdfeCabecMsgE cabecalhoSOAP = this.getCabecalhoSOAP();
        this.getLogger().debug(omElement.toString());
        MDFAutorizador3 autorizador = MDFAutorizador3.valueOfCodigoUF(this.config.getCUF());
        String endpoint = autorizador.getMDFeRecepcao(this.config.getAmbiente());
        if (endpoint == null) {
            throw new IllegalArgumentException("Nao foi possivel encontrar URL para Recepcao do MDFe, autorizador " + autorizador.name() + ", UF " + this.config.getCUF().name());
        }
        MDFeRecepcaoStub.MdfeRecepcaoLoteResult autorizacaoLoteResult = new MDFeRecepcaoStub(endpoint, this.config).mdfeRecepcaoLote(dados, cabecalhoSOAP);
        MDFEnvioLoteRetorno retorno = (MDFEnvioLoteRetorno)this.config.getPersister().read(MDFEnvioLoteRetorno.class, autorizacaoLoteResult.getExtraElement().toString());
        this.getLogger().debug(retorno.toString());
        return retorno;
    }

    private MDFeRecepcaoStub.MdfeCabecMsgE getCabecalhoSOAP() {
        MDFeRecepcaoStub.MdfeCabecMsg cabecalho = new MDFeRecepcaoStub.MdfeCabecMsg();
        cabecalho.setCUF(this.config.getCUF().getCodigoIbge());
        cabecalho.setVersaoDados("3.00");
        MDFeRecepcaoStub.MdfeCabecMsgE cabecalhoSOAP = new MDFeRecepcaoStub.MdfeCabecMsgE();
        cabecalhoSOAP.setMdfeCabecMsg(cabecalho);
        return cabecalhoSOAP;
    }

    private OMElement mdfeToOMElement(String documento) throws XMLStreamException {
        XMLInputFactory factory = XMLInputFactory.newInstance();
        factory.setProperty("javax.xml.stream.isCoalescing", false);
        XMLStreamReader reader = factory.createXMLStreamReader(new StringReader(documento));
        StAXOMBuilder builder = new StAXOMBuilder(reader);
        OMElement ome = builder.getDocumentElement();
        Iterator children = ome.getChildrenWithLocalName(MDFE_ELEMENTO);
        while (children.hasNext()) {
            OMElement omElement = (OMElement)children.next();
            if (omElement == null || !MDFE_ELEMENTO.equals(omElement.getLocalName())) continue;
            omElement.addAttribute("xmlns", "http://www.portalfiscal.inf.br/mdfe", null);
        }
        return ome;
    }
}

