/*
 * Decompiled with CFR 0.152.
 */
package com.fincatto.documentofiscal.mdfe3.webservices;

import com.fincatto.documentofiscal.DFLog;
import com.fincatto.documentofiscal.DFUnidadeFederativa;
import com.fincatto.documentofiscal.mdfe3.MDFeConfig;
import com.fincatto.documentofiscal.mdfe3.classes.MDFAutorizador3;
import com.fincatto.documentofiscal.mdfe3.classes.consultastatusservico.MDFeConsStatServ;
import com.fincatto.documentofiscal.mdfe3.classes.consultastatusservico.MDFeConsStatServRet;
import com.fincatto.documentofiscal.mdfe3.webservices.statusservico.MDFeStatusServicoStub;
import java.rmi.RemoteException;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.util.AXIOMUtil;

class WSStatusConsulta
implements DFLog {
    private static final String NOME_SERVICO = "STATUS";
    private final MDFeConfig config;

    WSStatusConsulta(MDFeConfig config) {
        this.config = config;
    }

    MDFeConsStatServRet consultaStatus(DFUnidadeFederativa uf) throws Exception {
        OMElement omElementConsulta = AXIOMUtil.stringToOM((String)WSStatusConsulta.gerarDadosConsulta(this.config).toString());
        this.getLogger().debug(omElementConsulta.toString());
        OMElement omElementResult = this.efetuaConsultaStatus(omElementConsulta, uf);
        this.getLogger().debug(omElementResult.toString());
        return (MDFeConsStatServRet)this.config.getPersister().read(MDFeConsStatServRet.class, omElementResult.toString());
    }

    private static MDFeConsStatServ gerarDadosConsulta(MDFeConfig config) {
        MDFeConsStatServ consStatServ = new MDFeConsStatServ();
        consStatServ.setAmbiente(config.getAmbiente());
        consStatServ.setVersao("3.00");
        consStatServ.setServico(NOME_SERVICO);
        return consStatServ;
    }

    private OMElement efetuaConsultaStatus(OMElement omElement, DFUnidadeFederativa unidadeFederativa) throws RemoteException {
        MDFeStatusServicoStub.MdfeCabecMsg cabec = new MDFeStatusServicoStub.MdfeCabecMsg();
        cabec.setCUF(unidadeFederativa.getCodigoIbge());
        cabec.setVersaoDados("3.00");
        MDFeStatusServicoStub.MdfeCabecMsgE cabecEnv = new MDFeStatusServicoStub.MdfeCabecMsgE();
        cabecEnv.setMdfeCabecMsg(cabec);
        MDFeStatusServicoStub.MdfeDadosMsg dados = new MDFeStatusServicoStub.MdfeDadosMsg();
        dados.setExtraElement(omElement);
        MDFAutorizador3 autorizador = MDFAutorizador3.valueOfCodigoUF(unidadeFederativa);
        String endpoint = autorizador.getMDFeStatusServico(this.config.getAmbiente());
        if (endpoint == null) {
            throw new IllegalArgumentException("Nao foi possivel encontrar URL para StatusServico, autorizador " + autorizador.name() + ", UF " + unidadeFederativa.name());
        }
        MDFeStatusServicoStub.MdfeStatusServicoMDFResult result = new MDFeStatusServicoStub(endpoint, this.config).mdfeStatusServicoMDF(dados, cabecEnv);
        return result.getExtraElement();
    }
}

