/*
 * Decompiled with CFR 0.152.
 */
package com.fincatto.documentofiscal.nfe.webservices.distribuicao;

import com.fincatto.documentofiscal.DFUnidadeFederativa;
import com.fincatto.documentofiscal.nfe.NFeConfig;
import com.fincatto.documentofiscal.nfe.classes.distribuicao.NFDistribuicaoConsultaChaveAcesso;
import com.fincatto.documentofiscal.nfe.classes.distribuicao.NFDistribuicaoConsultaNSU;
import com.fincatto.documentofiscal.nfe.classes.distribuicao.NFDistribuicaoInt;
import com.fincatto.documentofiscal.nfe.classes.distribuicao.NFDistribuicaoIntRetorno;
import com.fincatto.documentofiscal.nfe.classes.distribuicao.NFDistribuicaoNSU;
import com.fincatto.documentofiscal.nfe.webservices.distribuicao.NFeDistribuicaoDFeSoapStub;
import com.fincatto.documentofiscal.nfe310.classes.NFAutorizador31;
import com.fincatto.documentofiscal.validadores.DFXMLValidador;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.rmi.RemoteException;
import java.util.Base64;
import java.util.zip.GZIPInputStream;
import javax.xml.stream.XMLStreamException;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.util.AXIOMUtil;
import org.apache.commons.lang3.StringUtils;

public class WSDistribuicaoNFe {
    private final NFeConfig config;

    public WSDistribuicaoNFe(NFeConfig config) {
        this.config = config;
    }

    public NFDistribuicaoIntRetorno consultar(String cpfOuCnpj, DFUnidadeFederativa uf, String chaveAcesso, String nsu) throws Exception {
        return this.consultar(cpfOuCnpj, uf, chaveAcesso, nsu, null);
    }

    public NFDistribuicaoIntRetorno consultar(String cpfOuCnpj, DFUnidadeFederativa uf, String chaveAcesso, String nsu, String ultNsu) throws Exception {
        try {
            String xmlEnvio = this.gerarNFDistribuicaoInt(cpfOuCnpj, uf, chaveAcesso, nsu, ultNsu).toString();
            DFXMLValidador.validaConsultaDfe(xmlEnvio);
            OMElement ome = AXIOMUtil.stringToOM((String)xmlEnvio);
            NFeDistribuicaoDFeSoapStub.NFeDadosMsg_type0 dadosMsgType0 = new NFeDistribuicaoDFeSoapStub.NFeDadosMsg_type0();
            dadosMsgType0.setExtraElement(ome);
            NFeDistribuicaoDFeSoapStub.NFeDistDFeInteresse distDFeInteresse = new NFeDistribuicaoDFeSoapStub.NFeDistDFeInteresse();
            distDFeInteresse.setNFeDadosMsg(dadosMsgType0);
            NFeDistribuicaoDFeSoapStub stub = new NFeDistribuicaoDFeSoapStub(NFAutorizador31.AN.getNFeDistribuicaoDFe(this.config.getAmbiente()), this.config);
            NFeDistribuicaoDFeSoapStub.NFeDistDFeInteresseResponse result = stub.nfeDistDFeInteresse(distDFeInteresse);
            return (NFDistribuicaoIntRetorno)this.config.getPersister().read(NFDistribuicaoIntRetorno.class, result.getNFeDistDFeInteresseResult().getExtraElement().toString());
        }
        catch (RemoteException | XMLStreamException e) {
            e.printStackTrace();
            throw new Exception(e.getMessage());
        }
    }

    public static String decodeGZipToXml(String conteudoEncode) throws Exception {
        if (conteudoEncode == null || conteudoEncode.length() == 0) {
            return "";
        }
        byte[] conteudo = Base64.getDecoder().decode(conteudoEncode);
        try (GZIPInputStream gis = new GZIPInputStream(new ByteArrayInputStream(conteudo));){
            String string;
            try (BufferedReader bf = new BufferedReader(new InputStreamReader((InputStream)gis, StandardCharsets.UTF_8));){
                String line;
                StringBuilder outStr = new StringBuilder();
                while ((line = bf.readLine()) != null) {
                    outStr.append(line);
                }
                string = outStr.toString();
            }
            return string;
        }
    }

    private NFDistribuicaoInt gerarNFDistribuicaoInt(String cpfOuCnpj, DFUnidadeFederativa uf, String chaveAcesso, String nsu, String ultNsu) {
        NFDistribuicaoInt distDFeInt = new NFDistribuicaoInt();
        distDFeInt.setVersao("1.01");
        distDFeInt.setAmbiente(this.config.getAmbiente());
        distDFeInt.setUnidadeFederativaAutor(uf);
        if (cpfOuCnpj.length() == 11) {
            distDFeInt.setCpf(cpfOuCnpj);
        } else {
            distDFeInt.setCnpj(cpfOuCnpj);
        }
        if (StringUtils.isNotBlank((CharSequence)chaveAcesso)) {
            distDFeInt.setConsultaChaveAcesso(new NFDistribuicaoConsultaChaveAcesso().setChaveAcesso(chaveAcesso));
        } else if (StringUtils.isNotBlank((CharSequence)ultNsu)) {
            distDFeInt.setDistribuicaoNSU(new NFDistribuicaoNSU().setUltimoNSU(ultNsu));
        } else {
            distDFeInt.setConsultaNSU(new NFDistribuicaoConsultaNSU().setNsu(nsu));
        }
        return distDFeInt;
    }
}

