/*
 * Decompiled with CFR 0.152.
 */
package com.fincatto.documentofiscal.nfe310.classes;

import com.fincatto.documentofiscal.DFBase;
import com.fincatto.documentofiscal.DFUnidadeFederativa;
import com.fincatto.documentofiscal.validadores.DFStringValidador;
import org.simpleframework.xml.Element;

public class NFEndereco
extends DFBase {
    private static final long serialVersionUID = 417768837786948754L;
    @Element(name="xLgr")
    private String logradouro;
    @Element(name="nro")
    private String numero;
    @Element(name="xCpl", required=false)
    private String complemento;
    @Element(name="xBairro")
    private String bairro;
    @Element(name="cMun")
    private String codigoMunicipio;
    @Element(name="xMun")
    private String descricaoMunicipio;
    @Element(name="UF")
    private String uf;
    @Element(name="CEP", required=false)
    private String cep;
    @Element(name="cPais", required=false)
    private String codigoPais;
    @Element(name="xPais", required=false)
    private String descricaoPais;
    @Element(name="fone", required=false)
    private String telefone;

    public void setLogradouro(String logradouro) {
        DFStringValidador.tamanho60(logradouro, "Logradouro");
        this.logradouro = logradouro;
    }

    public void setNumero(String numero) {
        DFStringValidador.tamanho60(numero, "Numero do Endereco");
        this.numero = numero;
    }

    public void setComplemento(String complemento) {
        DFStringValidador.tamanho60(complemento, "Complemento");
        this.complemento = complemento;
    }

    public void setBairro(String bairro) {
        DFStringValidador.tamanho2ate60(bairro, "Bairro");
        this.bairro = bairro;
    }

    public void setCodigoMunicipio(String codigoMunicipio) {
        DFStringValidador.exatamente7(codigoMunicipio, "Codigo do Municipio");
        this.codigoMunicipio = codigoMunicipio;
    }

    public void setDescricaoMunicipio(String descricaoMunicipio) {
        DFStringValidador.tamanho60(descricaoMunicipio, "Descricao do Municipio");
        this.descricaoMunicipio = descricaoMunicipio;
    }

    public void setUf(DFUnidadeFederativa uf) {
        this.uf = uf.getCodigo();
    }

    public void setCep(String cep) {
        DFStringValidador.exatamente8(cep, "CEP");
        this.cep = cep;
    }

    public void setCodigoPais(String codigoPais) {
        DFStringValidador.tamanho2a4(codigoPais, "Codigo do pais");
        this.codigoPais = codigoPais;
    }

    public void setDescricaoPais(String descricaoPais) {
        DFStringValidador.tamanho60(descricaoPais, "Descricao do pais");
        this.descricaoPais = descricaoPais;
    }

    public void setTelefone(String telefone) {
        DFStringValidador.telefone(telefone);
        this.telefone = telefone;
    }

    public String getLogradouro() {
        return this.logradouro;
    }

    public String getNumero() {
        return this.numero;
    }

    public String getComplemento() {
        return this.complemento;
    }

    public String getBairro() {
        return this.bairro;
    }

    public String getCodigoMunicipio() {
        return this.codigoMunicipio;
    }

    public String getDescricaoMunicipio() {
        return this.descricaoMunicipio;
    }

    public String getUf() {
        return this.uf;
    }

    public String getCep() {
        return this.cep;
    }

    public String getCodigoPais() {
        return this.codigoPais;
    }

    public String getDescricaoPais() {
        return this.descricaoPais;
    }

    public String getTelefone() {
        return this.telefone;
    }
}

