/*
 * Decompiled with CFR 0.152.
 */
package com.fincatto.documentofiscal.nfe310.classes;

public enum NFRegimeTributario {
    SIMPLES_NACIONAL("1", "Simples nacional"),
    SIMPLES_NACIONAL_EXCESSO_RECEITA("2", "Simples nacional com excesso de sublimite da receita bruta"),
    NORMAL("3", "Regime normal");

    private final String codigo;
    private final String descricao;

    private NFRegimeTributario(String codigo, String descricao) {
        this.codigo = codigo;
        this.descricao = descricao;
    }

    public String getCodigo() {
        return this.codigo;
    }

    public String getDescricao() {
        return this.descricao;
    }

    public static NFRegimeTributario valueOfCodigo(String codigo) {
        for (NFRegimeTributario regimeTributario : NFRegimeTributario.values()) {
            if (!regimeTributario.getCodigo().equals(codigo)) continue;
            return regimeTributario;
        }
        return null;
    }

    public String toString() {
        return this.codigo + " - " + this.descricao;
    }
}

