/*
 * Decompiled with CFR 0.152.
 */
package com.fincatto.documentofiscal.nfe310.classes.nota;

import com.fincatto.documentofiscal.DFBase;
import com.fincatto.documentofiscal.nfe310.classes.nota.NFNotaInfoAvulsa;
import com.fincatto.documentofiscal.nfe310.classes.nota.NFNotaInfoCana;
import com.fincatto.documentofiscal.nfe310.classes.nota.NFNotaInfoCobranca;
import com.fincatto.documentofiscal.nfe310.classes.nota.NFNotaInfoCompra;
import com.fincatto.documentofiscal.nfe310.classes.nota.NFNotaInfoDestinatario;
import com.fincatto.documentofiscal.nfe310.classes.nota.NFNotaInfoEmitente;
import com.fincatto.documentofiscal.nfe310.classes.nota.NFNotaInfoExportacao;
import com.fincatto.documentofiscal.nfe310.classes.nota.NFNotaInfoIdentificacao;
import com.fincatto.documentofiscal.nfe310.classes.nota.NFNotaInfoInformacoesAdicionais;
import com.fincatto.documentofiscal.nfe310.classes.nota.NFNotaInfoItem;
import com.fincatto.documentofiscal.nfe310.classes.nota.NFNotaInfoLocal;
import com.fincatto.documentofiscal.nfe310.classes.nota.NFNotaInfoPagamento;
import com.fincatto.documentofiscal.nfe310.classes.nota.NFNotaInfoTotal;
import com.fincatto.documentofiscal.nfe310.classes.nota.NFNotaInfoTransporte;
import com.fincatto.documentofiscal.nfe310.classes.nota.NFPessoaAutorizadaDownloadNFe;
import com.fincatto.documentofiscal.validadores.DFBigDecimalValidador;
import com.fincatto.documentofiscal.validadores.DFListValidador;
import com.fincatto.documentofiscal.validadores.DFStringValidador;
import java.math.BigDecimal;
import java.util.List;
import org.simpleframework.xml.Attribute;
import org.simpleframework.xml.Element;
import org.simpleframework.xml.ElementList;
import org.simpleframework.xml.Namespace;
import org.simpleframework.xml.Root;

@Root(name="infNFe")
@Namespace(reference="http://www.portalfiscal.inf.br/nfe")
public class NFNotaInfo
extends DFBase {
    private static final long serialVersionUID = 4569152242139670228L;
    public static final String IDENT = "NFe";
    @Attribute(name="Id")
    private String identificador;
    @Attribute(name="versao")
    private String versao;
    @Element(name="ide")
    private NFNotaInfoIdentificacao identificacao;
    @Element(name="emit")
    private NFNotaInfoEmitente emitente;
    @Element(name="avulsa", required=false)
    private NFNotaInfoAvulsa avulsa;
    @Element(name="dest", required=false)
    private NFNotaInfoDestinatario destinatario;
    @Element(name="retirada", required=false)
    private NFNotaInfoLocal retirada;
    @Element(name="entrega", required=false)
    private NFNotaInfoLocal entrega;
    @ElementList(entry="autXML", inline=true, required=false)
    private List<NFPessoaAutorizadaDownloadNFe> pessoasAutorizadasDownloadNFe;
    @ElementList(entry="det", inline=true)
    private List<NFNotaInfoItem> itens;
    @Element(name="total")
    private NFNotaInfoTotal total;
    @Element(name="transp")
    private NFNotaInfoTransporte transporte;
    @Element(name="cobr", required=false)
    private NFNotaInfoCobranca cobranca;
    @ElementList(entry="pag", inline=true, required=false)
    private List<NFNotaInfoPagamento> pagamentos;
    @Element(name="infAdic", required=false)
    private NFNotaInfoInformacoesAdicionais informacoesAdicionais;
    @Element(name="exporta", required=false)
    private NFNotaInfoExportacao exportacao;
    @Element(name="compra", required=false)
    private NFNotaInfoCompra compra;
    @Element(name="cana", required=false)
    private NFNotaInfoCana cana;

    public String getChaveAcesso() {
        return this.identificador.replace(IDENT, "");
    }

    public void setIdentificador(String identificador) {
        DFStringValidador.exatamente44N(identificador, "Identificador");
        this.identificador = IDENT + identificador;
    }

    public String getIdentificador() {
        return this.identificador;
    }

    public void setVersao(BigDecimal versao) {
        this.versao = DFBigDecimalValidador.tamanho4Com2CasasDecimais(versao, "Versao");
    }

    public NFNotaInfoIdentificacao getIdentificacao() {
        return this.identificacao;
    }

    public void setIdentificacao(NFNotaInfoIdentificacao identificacao) {
        this.identificacao = identificacao;
    }

    public void setEmitente(NFNotaInfoEmitente emitente) {
        this.emitente = emitente;
    }

    public void setAvulsa(NFNotaInfoAvulsa avulsa) {
        this.avulsa = avulsa;
    }

    public NFNotaInfoDestinatario getDestinatario() {
        return this.destinatario;
    }

    public void setDestinatario(NFNotaInfoDestinatario destinatario) {
        this.destinatario = destinatario;
    }

    public void setItens(List<NFNotaInfoItem> itens) {
        DFListValidador.tamanho990(itens, "Itens da Nota");
        this.itens = itens;
    }

    public void setRetirada(NFNotaInfoLocal retirada) {
        this.retirada = retirada;
    }

    public void setEntrega(NFNotaInfoLocal entrega) {
        this.entrega = entrega;
    }

    public void setCobranca(NFNotaInfoCobranca cobranca) {
        this.cobranca = cobranca;
    }

    public void setTotal(NFNotaInfoTotal total) {
        this.total = total;
    }

    public void setTransporte(NFNotaInfoTransporte transporte) {
        this.transporte = transporte;
    }

    public void setInformacoesAdicionais(NFNotaInfoInformacoesAdicionais informacoesAdicionais) {
        this.informacoesAdicionais = informacoesAdicionais;
    }

    public void setExportacao(NFNotaInfoExportacao exportacao) {
        this.exportacao = exportacao;
    }

    public void setCompra(NFNotaInfoCompra compra) {
        this.compra = compra;
    }

    public void setCana(NFNotaInfoCana cana) {
        this.cana = cana;
    }

    public void setPessoasAutorizadasDownloadNFe(List<NFPessoaAutorizadaDownloadNFe> pessoasAutorizadasDownloadNFe) {
        DFListValidador.tamanho10(pessoasAutorizadasDownloadNFe, "Pessoas Autorizadas Download NFe");
        this.pessoasAutorizadasDownloadNFe = pessoasAutorizadasDownloadNFe;
    }

    public void setPagamentos(List<NFNotaInfoPagamento> pagamentos) {
        DFListValidador.tamanho100(pagamentos, "Pagamentos");
        this.pagamentos = pagamentos;
    }

    public String getVersao() {
        return this.versao;
    }

    public NFNotaInfoEmitente getEmitente() {
        return this.emitente;
    }

    public NFNotaInfoAvulsa getAvulsa() {
        return this.avulsa;
    }

    public NFNotaInfoLocal getRetirada() {
        return this.retirada;
    }

    public NFNotaInfoLocal getEntrega() {
        return this.entrega;
    }

    public List<NFPessoaAutorizadaDownloadNFe> getPessoasAutorizadasDownloadNFe() {
        return this.pessoasAutorizadasDownloadNFe;
    }

    public List<NFNotaInfoItem> getItens() {
        return this.itens;
    }

    public NFNotaInfoTotal getTotal() {
        return this.total;
    }

    public NFNotaInfoTransporte getTransporte() {
        return this.transporte;
    }

    public NFNotaInfoCobranca getCobranca() {
        return this.cobranca;
    }

    public List<NFNotaInfoPagamento> getPagamentos() {
        return this.pagamentos;
    }

    public NFNotaInfoInformacoesAdicionais getInformacoesAdicionais() {
        return this.informacoesAdicionais;
    }

    public NFNotaInfoExportacao getExportacao() {
        return this.exportacao;
    }

    public NFNotaInfoCompra getCompra() {
        return this.compra;
    }

    public NFNotaInfoCana getCana() {
        return this.cana;
    }
}

