/*
 * Decompiled with CFR 0.152.
 */
package com.fincatto.documentofiscal.nfe310.classes.nota;

import com.fincatto.documentofiscal.DFBase;
import com.fincatto.documentofiscal.validadores.DFBigDecimalValidador;
import java.math.BigDecimal;
import org.simpleframework.xml.Element;

public class NFNotaInfoICMSTotal
extends DFBase {
    private static final long serialVersionUID = 1644701343314788528L;
    @Element(name="vBC")
    private String baseCalculoICMS;
    @Element(name="vICMS")
    private String valorTotalICMS;
    @Element(name="vICMSDeson")
    private String valorICMSDesonerado;
    @Element(name="vFCPUFDest", required=false)
    private String valorICMSFundoCombatePobreza;
    @Element(name="vICMSUFDest", required=false)
    private String valorICMSPartilhaDestinatario;
    @Element(name="vICMSUFRemet", required=false)
    private String valorICMSPartilhaRementente;
    @Element(name="vBCST")
    private String baseCalculoICMSST;
    @Element(name="vST")
    private String valorTotalICMSST;
    @Element(name="vProd")
    private String valorTotalDosProdutosServicos;
    @Element(name="vFrete")
    private String valorTotalFrete;
    @Element(name="vSeg")
    private String valorTotalSeguro;
    @Element(name="vDesc")
    private String valorTotalDesconto;
    @Element(name="vII")
    private String valorTotalII;
    @Element(name="vIPI")
    private String valorTotalIPI;
    @Element(name="vPIS")
    private String valorPIS;
    @Element(name="vCOFINS")
    private String valorCOFINS;
    @Element(name="vOutro")
    private String outrasDespesasAcessorias;
    @Element(name="vNF")
    private String valorTotalNFe;
    @Element(name="vTotTrib", required=false)
    private String valorTotalTributos;

    public void setBaseCalculoICMS(BigDecimal baseCalculoICMS) {
        this.baseCalculoICMS = DFBigDecimalValidador.tamanho15Com2CasasDecimais(baseCalculoICMS, "Base de Calculo ICMS Total");
    }

    public void setValorTotalICMS(BigDecimal valorTotalICMS) {
        this.valorTotalICMS = DFBigDecimalValidador.tamanho15Com2CasasDecimais(valorTotalICMS, "Valalor Total ICMS");
    }

    public void setBaseCalculoICMSST(BigDecimal baseCalculoICMSST) {
        this.baseCalculoICMSST = DFBigDecimalValidador.tamanho15Com2CasasDecimais(baseCalculoICMSST, "Base de Calculo ICMS ST Total");
    }

    public void setValorTotalICMSST(BigDecimal valorTotalICMSST) {
        this.valorTotalICMSST = DFBigDecimalValidador.tamanho15Com2CasasDecimais(valorTotalICMSST, "Valor Total ICMS ST");
    }

    public void setValorTotalDosProdutosServicos(BigDecimal valorTotalDosProdutosServicos) {
        this.valorTotalDosProdutosServicos = DFBigDecimalValidador.tamanho15Com2CasasDecimais(valorTotalDosProdutosServicos, "Valor Total Produtos e Servicos");
    }

    public void setValorTotalFrete(BigDecimal valorTotalFrete) {
        this.valorTotalFrete = DFBigDecimalValidador.tamanho15Com2CasasDecimais(valorTotalFrete, "Valor Total Frete");
    }

    public void setValorTotalSeguro(BigDecimal valorTotalSeguro) {
        this.valorTotalSeguro = DFBigDecimalValidador.tamanho15Com2CasasDecimais(valorTotalSeguro, "Valor Total Seguro");
    }

    public void setValorTotalDesconto(BigDecimal valorTotalDesconto) {
        this.valorTotalDesconto = DFBigDecimalValidador.tamanho15Com2CasasDecimais(valorTotalDesconto, "Valor Total Desconto");
    }

    public void setValorTotalII(BigDecimal valorTotalII) {
        this.valorTotalII = DFBigDecimalValidador.tamanho15Com2CasasDecimais(valorTotalII, "Valor Total II");
    }

    public void setValorTotalIPI(BigDecimal valorTotalIPI) {
        this.valorTotalIPI = DFBigDecimalValidador.tamanho15Com2CasasDecimais(valorTotalIPI, "Valor Total IPI");
    }

    public void setValorPIS(BigDecimal valorPIS) {
        this.valorPIS = DFBigDecimalValidador.tamanho15Com2CasasDecimais(valorPIS, "Valor Total PIS");
    }

    public void setValorCOFINS(BigDecimal valorCOFINS) {
        this.valorCOFINS = DFBigDecimalValidador.tamanho15Com2CasasDecimais(valorCOFINS, "Valor Total COFINS");
    }

    public void setOutrasDespesasAcessorias(BigDecimal outrasDespesasAcessorias) {
        this.outrasDespesasAcessorias = DFBigDecimalValidador.tamanho15Com2CasasDecimais(outrasDespesasAcessorias, "Outras Despesas Acessorias");
    }

    public void setValorTotalNFe(BigDecimal valorTotalNFe) {
        this.valorTotalNFe = DFBigDecimalValidador.tamanho15Com2CasasDecimais(valorTotalNFe, "Valor Total NFe");
    }

    public void setValorTotalTributos(BigDecimal valorTotalTributos) {
        this.valorTotalTributos = DFBigDecimalValidador.tamanho15Com2CasasDecimais(valorTotalTributos, "Valor Total Tributos");
    }

    public void setValorICMSDesonerado(BigDecimal valorICMSDesonerado) {
        this.valorICMSDesonerado = DFBigDecimalValidador.tamanho15Com2CasasDecimais(valorICMSDesonerado, "Valor ICMS Desonerado");
    }

    public String getBaseCalculoICMS() {
        return this.baseCalculoICMS;
    }

    public String getValorTotalICMS() {
        return this.valorTotalICMS;
    }

    public String getValorICMSDesonerado() {
        return this.valorICMSDesonerado;
    }

    public String getBaseCalculoICMSST() {
        return this.baseCalculoICMSST;
    }

    public String getValorTotalICMSST() {
        return this.valorTotalICMSST;
    }

    public String getValorTotalDosProdutosServicos() {
        return this.valorTotalDosProdutosServicos;
    }

    public String getValorTotalFrete() {
        return this.valorTotalFrete;
    }

    public String getValorTotalSeguro() {
        return this.valorTotalSeguro;
    }

    public String getValorTotalDesconto() {
        return this.valorTotalDesconto;
    }

    public String getValorTotalII() {
        return this.valorTotalII;
    }

    public String getValorTotalIPI() {
        return this.valorTotalIPI;
    }

    public String getValorPIS() {
        return this.valorPIS;
    }

    public String getValorCOFINS() {
        return this.valorCOFINS;
    }

    public String getOutrasDespesasAcessorias() {
        return this.outrasDespesasAcessorias;
    }

    public String getValorTotalNFe() {
        return this.valorTotalNFe;
    }

    public String getValorTotalTributos() {
        return this.valorTotalTributos;
    }

    public String getValorICMSFundoCombatePobreza() {
        return this.valorICMSFundoCombatePobreza;
    }

    public void setValorICMSFundoCombatePobreza(BigDecimal valorICMSFundoCombatePobreza) {
        this.valorICMSFundoCombatePobreza = DFBigDecimalValidador.tamanho15Com2CasasDecimais(valorICMSFundoCombatePobreza, "Valor ICMS Fundo Combate a Pobreza");
    }

    public String getValorICMSPartilhaDestinatario() {
        return this.valorICMSPartilhaDestinatario;
    }

    public void setValorICMSPartilhaDestinatario(BigDecimal valorICMSPartilhaDestinatario) {
        this.valorICMSPartilhaDestinatario = DFBigDecimalValidador.tamanho15Com2CasasDecimais(valorICMSPartilhaDestinatario, "Valor ICMS Partilha Destinatario");
    }

    public String getValorICMSPartilhaRementente() {
        return this.valorICMSPartilhaRementente;
    }

    public void setValorICMSPartilhaRementente(BigDecimal valorICMSPartilhaRementente) {
        this.valorICMSPartilhaRementente = DFBigDecimalValidador.tamanho15Com2CasasDecimais(valorICMSPartilhaRementente, "Valor ICMS Partilha Remetente");
    }
}

