/*
 * Decompiled with CFR 0.152.
 */
package com.fincatto.documentofiscal.nfe310.classes.nota;

import com.fincatto.documentofiscal.DFBase;
import com.fincatto.documentofiscal.nfe310.classes.nota.NFNotaInfoRegimeEspecialTributacao;
import com.fincatto.documentofiscal.validadores.DFBigDecimalValidador;
import java.math.BigDecimal;
import java.time.LocalDate;
import org.simpleframework.xml.Element;

public class NFNotaInfoISSQNTotal
extends DFBase {
    private static final long serialVersionUID = 5902409212301825888L;
    @Element(name="vServ", required=false)
    private String valorTotalServicosSobNaoIncidenciaNaoTributadosICMS;
    @Element(name="vBC", required=false)
    private String baseCalculoISS;
    @Element(name="vISS", required=false)
    private String valorTotalISS;
    @Element(name="vPIS", required=false)
    private String valorPISsobreServicos;
    @Element(name="vCOFINS", required=false)
    private String valorCOFINSsobreServicos;
    @Element(name="dCompet")
    private LocalDate dataPrestacaoServico;
    @Element(name="vDeducao", required=false)
    private String valorDeducao;
    @Element(name="vOutro", required=false)
    private String valorOutros;
    @Element(name="vDescIncond", required=false)
    private String valorTotalDescontoIncondicionado;
    @Element(name="vDescCond", required=false)
    private String valorTotalDescontoCondicionado;
    @Element(name="vISSRet", required=false)
    private String valorTotalRetencaoISS;
    @Element(name="cRegTrib", required=false)
    private NFNotaInfoRegimeEspecialTributacao tributacao;

    public void setValorTotalServicosSobNaoIncidenciaNaoTributadosICMS(BigDecimal valorTotalServicosSobNaoIncidenciaNaoTributadosICMS) {
        this.valorTotalServicosSobNaoIncidenciaNaoTributadosICMS = DFBigDecimalValidador.tamanho15Com2CasasDecimais(valorTotalServicosSobNaoIncidenciaNaoTributadosICMS, "Valor Total Servicos Sob Nao Incidencia Nao Tributados ICMS");
    }

    public void setBaseCalculoISS(BigDecimal baseCalculoISS) {
        this.baseCalculoISS = DFBigDecimalValidador.tamanho15Com2CasasDecimais(baseCalculoISS, "Base de Calculo ISS Total");
    }

    public void setValorTotalISS(BigDecimal valorTotalISS) {
        this.valorTotalISS = DFBigDecimalValidador.tamanho15Com2CasasDecimais(valorTotalISS, "Valor Total ISS");
    }

    public void setValorPISsobreServicos(BigDecimal valorPISsobreServicos) {
        this.valorPISsobreServicos = DFBigDecimalValidador.tamanho15Com2CasasDecimais(valorPISsobreServicos, "Valor Total PIS Sobre Servicos");
    }

    public void setValorCOFINSsobreServicos(BigDecimal valorCOFINSsobreServicos) {
        this.valorCOFINSsobreServicos = DFBigDecimalValidador.tamanho15Com2CasasDecimais(valorCOFINSsobreServicos, "Valor Total COFINS Sobre Servicos");
    }

    public void setDataPrestacaoServico(LocalDate dataPrestacaoServico) {
        this.dataPrestacaoServico = dataPrestacaoServico;
    }

    public void setValorDeducao(BigDecimal valorDeducao) {
        this.valorDeducao = DFBigDecimalValidador.tamanho15Com2CasasDecimais(valorDeducao, "Valor Total Deducao");
    }

    public void setTributacao(NFNotaInfoRegimeEspecialTributacao tributacao) {
        this.tributacao = tributacao;
    }

    public void setValorOutros(BigDecimal valorOutros) {
        this.valorOutros = DFBigDecimalValidador.tamanho15Com2CasasDecimais(valorOutros, "Valor Total Outros");
    }

    public void setValorTotalDescontoCondicionado(BigDecimal valorTotalDescontoCondicionado) {
        this.valorTotalDescontoCondicionado = DFBigDecimalValidador.tamanho15Com2CasasDecimais(valorTotalDescontoCondicionado, "Valor Total Desconto Condicionado");
    }

    public void setValorTotalDescontoIncondicionado(BigDecimal valorTotalDescontoIncondicionado) {
        this.valorTotalDescontoIncondicionado = DFBigDecimalValidador.tamanho15Com2CasasDecimais(valorTotalDescontoIncondicionado, "Valor Total Desconto Incondicionado");
    }

    public void setValorTotalRetencaoISS(BigDecimal valorTotalRetencaoISS) {
        this.valorTotalRetencaoISS = DFBigDecimalValidador.tamanho15Com2CasasDecimais(valorTotalRetencaoISS, "Valor Total Retencao ISS");
    }

    public String getValorTotalServicosSobNaoIncidenciaNaoTributadosICMS() {
        return this.valorTotalServicosSobNaoIncidenciaNaoTributadosICMS;
    }

    public String getBaseCalculoISS() {
        return this.baseCalculoISS;
    }

    public String getValorTotalISS() {
        return this.valorTotalISS;
    }

    public String getValorPISsobreServicos() {
        return this.valorPISsobreServicos;
    }

    public String getValorCOFINSsobreServicos() {
        return this.valorCOFINSsobreServicos;
    }

    public LocalDate getDataPrestacaoServico() {
        return this.dataPrestacaoServico;
    }

    public String getValorDeducao() {
        return this.valorDeducao;
    }

    public String getValorOutros() {
        return this.valorOutros;
    }

    public String getValorTotalDescontoIncondicionado() {
        return this.valorTotalDescontoIncondicionado;
    }

    public String getValorTotalDescontoCondicionado() {
        return this.valorTotalDescontoCondicionado;
    }

    public String getValorTotalRetencaoISS() {
        return this.valorTotalRetencaoISS;
    }

    public NFNotaInfoRegimeEspecialTributacao getTributacao() {
        return this.tributacao;
    }
}

