/*
 * Decompiled with CFR 0.152.
 */
package com.fincatto.documentofiscal.nfe310.classes.nota;

import com.fincatto.documentofiscal.DFBase;
import com.fincatto.documentofiscal.nfe310.classes.nota.NFImpostoDevolvido;
import com.fincatto.documentofiscal.nfe310.classes.nota.NFNotaInfoItemImposto;
import com.fincatto.documentofiscal.nfe310.classes.nota.NFNotaInfoItemProduto;
import com.fincatto.documentofiscal.validadores.DFIntegerValidador;
import com.fincatto.documentofiscal.validadores.DFStringValidador;
import org.simpleframework.xml.Attribute;
import org.simpleframework.xml.Element;

public class NFNotaInfoItem
extends DFBase {
    private static final long serialVersionUID = 362646693945373643L;
    @Attribute(name="nItem")
    private Integer numeroItem;
    @Element(name="prod")
    private NFNotaInfoItemProduto produto;
    @Element(name="imposto")
    private NFNotaInfoItemImposto imposto;
    @Element(name="impostoDevol", required=false)
    private NFImpostoDevolvido impostoDevolvido;
    @Element(name="infAdProd", required=false)
    private String informacoesAdicionais;

    public void setNumeroItem(Integer numeroItem) {
        DFIntegerValidador.tamanho3maximo990(numeroItem, "Numero do Item");
        this.numeroItem = numeroItem;
    }

    public void setInformacoesAdicionais(String informacoesAdicionais) {
        DFStringValidador.tamanho500(informacoesAdicionais, "Informacoes Adicionais do Item");
        this.informacoesAdicionais = informacoesAdicionais;
    }

    public void setProduto(NFNotaInfoItemProduto produto) {
        this.produto = produto;
    }

    public void setImposto(NFNotaInfoItemImposto imposto) {
        this.imposto = imposto;
    }

    public Integer getNumeroItem() {
        return this.numeroItem;
    }

    public NFNotaInfoItemProduto getProduto() {
        return this.produto;
    }

    public NFNotaInfoItemImposto getImposto() {
        return this.imposto;
    }

    public String getInformacoesAdicionais() {
        return this.informacoesAdicionais;
    }

    public NFImpostoDevolvido getImpostoDevolvido() {
        return this.impostoDevolvido;
    }

    public void setImpostoDevolvido(NFImpostoDevolvido impostoDevolvido) {
        this.impostoDevolvido = impostoDevolvido;
    }
}

