/*
 * Decompiled with CFR 0.152.
 */
package com.fincatto.documentofiscal.nfe310.classes.nota;

import com.fincatto.documentofiscal.DFBase;
import com.fincatto.documentofiscal.nfe310.classes.NFNotaSituacaoOperacionalSimplesNacional;
import com.fincatto.documentofiscal.nfe310.classes.NFOrigem;
import com.fincatto.documentofiscal.validadores.DFBigDecimalValidador;
import java.math.BigDecimal;
import org.simpleframework.xml.Element;

public class NFNotaInfoItemImpostoICMSSN101
extends DFBase {
    private static final long serialVersionUID = -3123413337026509697L;
    @Element(name="orig")
    private NFOrigem origem;
    @Element(name="CSOSN")
    private NFNotaSituacaoOperacionalSimplesNacional situacaoOperacaoSN;
    @Element(name="pCredSN")
    private String percentualAliquotaAplicavelCalculoCreditoSN;
    @Element(name="vCredICMSSN")
    private String valorCreditoICMSSN;

    public void setOrigem(NFOrigem origem) {
        this.origem = origem;
    }

    public void setSituacaoOperacaoSN(NFNotaSituacaoOperacionalSimplesNacional situacaoOperacaoSN) {
        this.situacaoOperacaoSN = situacaoOperacaoSN;
    }

    public void setPercentualAliquotaAplicavelCalculoCreditoSN(BigDecimal percentualAliquotaAplicavelCalculoCreditoSN) {
        this.percentualAliquotaAplicavelCalculoCreditoSN = DFBigDecimalValidador.tamanho7ComAte4CasasDecimais(percentualAliquotaAplicavelCalculoCreditoSN, "Percentual Aliquota Aplicavel Calculo Credito SN ICMSSN101");
    }

    public void setValorCreditoICMSSN(BigDecimal valorCreditoICMSSN) {
        this.valorCreditoICMSSN = DFBigDecimalValidador.tamanho15Com2CasasDecimais(valorCreditoICMSSN, "Valor Credito ICMSSN101");
    }

    public NFOrigem getOrigem() {
        return this.origem;
    }

    public NFNotaSituacaoOperacionalSimplesNacional getSituacaoOperacaoSN() {
        return this.situacaoOperacaoSN;
    }

    public String getPercentualAliquotaAplicavelCalculoCreditoSN() {
        return this.percentualAliquotaAplicavelCalculoCreditoSN;
    }

    public String getValorCreditoICMSSN() {
        return this.valorCreditoICMSSN;
    }
}

