/*
 * Decompiled with CFR 0.152.
 */
package com.fincatto.documentofiscal.nfe310.classes.nota;

import com.fincatto.documentofiscal.DFBase;
import com.fincatto.documentofiscal.DFUnidadeFederativa;
import com.fincatto.documentofiscal.nfe310.classes.nota.NFNotaInfoItemProdutoCombustivelCIDE;
import com.fincatto.documentofiscal.nfe310.classes.nota.NFNotaInfoItemProdutoCombustivelEncerrante;
import com.fincatto.documentofiscal.validadores.DFBigDecimalValidador;
import com.fincatto.documentofiscal.validadores.DFStringValidador;
import java.math.BigDecimal;
import org.simpleframework.xml.Element;

public class NFNotaInfoItemProdutoCombustivel
extends DFBase {
    private static final long serialVersionUID = -2899516480924530882L;
    @Element(name="cProdANP")
    private String codigoProdutoANP = null;
    @Element(name="pMixGN", required=false)
    private String percentualGasNatural;
    @Element(name="CODIF", required=false)
    private String codigoAutorizacaoCOFIF = null;
    @Element(name="qTemp", required=false)
    private String quantidade = null;
    @Element(name="UFCons")
    private String uf = null;
    @Element(name="CIDE", required=false)
    private NFNotaInfoItemProdutoCombustivelCIDE cide = null;
    @Element(name="encerrante", required=false)
    private NFNotaInfoItemProdutoCombustivelEncerrante encerrante = null;

    public void setCodigoProdutoANP(String codigoProdutoANP) {
        DFStringValidador.exatamente9(codigoProdutoANP, "Codigo Produto ANP Combustivel");
        this.codigoProdutoANP = codigoProdutoANP;
    }

    public void setCodigoAutorizacaoCODIF(String codigoAutorizacaoCODIF) {
        DFStringValidador.tamanho21(codigoAutorizacaoCODIF, "Codigo Autorizacao CODIF Combustivel");
        this.codigoAutorizacaoCOFIF = codigoAutorizacaoCODIF;
    }

    public void setQuantidade(BigDecimal quantidade) {
        this.quantidade = DFBigDecimalValidador.tamanho16Com4CasasDecimais(quantidade, "Quantidade Combustivel");
    }

    public void setUf(DFUnidadeFederativa uf) {
        this.uf = uf.getCodigo();
    }

    public void setCide(NFNotaInfoItemProdutoCombustivelCIDE cide) {
        this.cide = cide;
    }

    public void setPercentualGasNatural(BigDecimal percentualGasNatural) {
        this.percentualGasNatural = DFBigDecimalValidador.tamanho5Com2CasasDecimais(percentualGasNatural, "Percentual Gas Natural Combustivel");
    }

    public void setEncerrante(NFNotaInfoItemProdutoCombustivelEncerrante encerrante) {
        this.encerrante = encerrante;
    }

    public String getCodigoProdutoANP() {
        return this.codigoProdutoANP;
    }

    public String getPercentualGasNatural() {
        return this.percentualGasNatural;
    }

    public String getCodigoAutorizacaoCOFIF() {
        return this.codigoAutorizacaoCOFIF;
    }

    public String getQuantidade() {
        return this.quantidade;
    }

    public String getUf() {
        return this.uf;
    }

    public NFNotaInfoItemProdutoCombustivelCIDE getCide() {
        return this.cide;
    }

    public NFNotaInfoItemProdutoCombustivelEncerrante getEncerrante() {
        return this.encerrante;
    }
}

