/*
 * Decompiled with CFR 0.152.
 */
package com.fincatto.documentofiscal.nfe310.classes.nota;

import com.fincatto.documentofiscal.DFBase;
import com.fincatto.documentofiscal.validadores.DFBigDecimalValidador;
import java.math.BigDecimal;
import org.simpleframework.xml.Element;

public class NFNotaInfoItemProdutoCombustivelCIDE
extends DFBase {
    private static final long serialVersionUID = -2869376510830652913L;
    @Element(name="qBCProd")
    private String quantidadeBCCIDE = null;
    @Element(name="vAliqProd")
    private String valorAliquota = null;
    @Element(name="vCIDE")
    private String valor = null;

    public void setQuantidadeBCCIDE(BigDecimal quantidade) {
        this.quantidadeBCCIDE = DFBigDecimalValidador.tamanho16Com4CasasDecimais(quantidade, "Quantidade Combustivel CIDE");
    }

    public void setValorAliquota(BigDecimal valorAliquota) {
        this.valorAliquota = DFBigDecimalValidador.tamanho15Com4CasasDecimais(valorAliquota, "Valor Aliquota Combustivel CIDE");
    }

    public void setValor(BigDecimal valor) {
        this.valor = DFBigDecimalValidador.tamanho15Com2CasasDecimais(valor, "Valor Combustivel CIDE");
    }

    public String getQuantidadeBCCIDE() {
        return this.quantidadeBCCIDE;
    }

    public String getValorAliquota() {
        return this.valorAliquota;
    }

    public String getValor() {
        return this.valor;
    }
}

