/*
 * Decompiled with CFR 0.152.
 */
package com.fincatto.documentofiscal.nfe310.classes.nota;

import com.fincatto.documentofiscal.DFBase;
import com.fincatto.documentofiscal.nfe310.classes.nota.NFFormaPagamentoMoeda;
import com.fincatto.documentofiscal.nfe310.classes.nota.NFNotaInfoCartao;
import com.fincatto.documentofiscal.validadores.DFBigDecimalValidador;
import java.math.BigDecimal;
import org.simpleframework.xml.Element;

public class NFNotaInfoPagamento
extends DFBase {
    private static final long serialVersionUID = -2613537583415054150L;
    @Element(name="tPag")
    private NFFormaPagamentoMoeda formaPagamentoMoeda;
    @Element(name="vPag")
    private String valorPagamento;
    @Element(name="card", required=false)
    private NFNotaInfoCartao cartao;

    public void setCartao(NFNotaInfoCartao cartao) {
        this.cartao = cartao;
    }

    public void setFormaPagamentoMoeda(NFFormaPagamentoMoeda formaPagamentoMoeda) {
        this.formaPagamentoMoeda = formaPagamentoMoeda;
    }

    public void setValorPagamento(BigDecimal valorPagamento) {
        this.valorPagamento = DFBigDecimalValidador.tamanho15Com2CasasDecimais(valorPagamento, "Valor Pagamento");
    }

    public NFFormaPagamentoMoeda getFormaPagamentoMoeda() {
        return this.formaPagamentoMoeda;
    }

    public String getValorPagamento() {
        return this.valorPagamento;
    }

    public NFNotaInfoCartao getCartao() {
        return this.cartao;
    }
}

