/*
 * Decompiled with CFR 0.152.
 */
package com.fincatto.documentofiscal.nfe310.classes.nota;

import com.fincatto.documentofiscal.DFBase;
import com.fincatto.documentofiscal.validadores.DFBigDecimalValidador;
import com.fincatto.documentofiscal.validadores.DFIntegerValidador;
import com.fincatto.documentofiscal.validadores.DFStringValidador;
import java.math.BigDecimal;
import org.simpleframework.xml.Element;

public class NFNotaInfoRetencaoICMSTransporte
extends DFBase {
    private static final long serialVersionUID = -5222569391852128441L;
    @Element(name="vServ")
    private String valorServico;
    @Element(name="vBCRet")
    private String bcRetencaoICMS;
    @Element(name="pICMSRet")
    private String aliquotaRetencao;
    @Element(name="vICMSRet")
    private String valorICMSRetido;
    @Element(name="CFOP")
    private Integer cfop;
    @Element(name="cMunFG")
    private String codigoMunicipioOcorrenciaFatoGeradorICMSTransporte;

    public void setValorServico(BigDecimal valorServico) {
        this.valorServico = DFBigDecimalValidador.tamanho15Com2CasasDecimais(valorServico, "Valor Servico Retencao ICMS Transporte");
    }

    public void setBcRetencaoICMS(BigDecimal bcRetencaoICMS) {
        this.bcRetencaoICMS = DFBigDecimalValidador.tamanho15Com2CasasDecimais(bcRetencaoICMS, "BC Retencao ICMS Transporte");
    }

    public void setAliquotaRetencao(BigDecimal aliquotaRetencao) {
        this.aliquotaRetencao = DFBigDecimalValidador.tamanho7ComAte4CasasDecimais(aliquotaRetencao, "Aliquota Retencao ICMS Transporte");
    }

    public void setValorICMSRetido(BigDecimal valorICMSRetido) {
        this.valorICMSRetido = DFBigDecimalValidador.tamanho15Com2CasasDecimais(valorICMSRetido, "Valor ICMS Retido Transporte");
    }

    public void setCfop(Integer cfop) {
        DFIntegerValidador.tamanho4(cfop, "CFOP Retencao ICMS Transporte");
        this.cfop = cfop;
    }

    public void setCodigoMunicipioOcorrenciaFatoGeradorICMSTransporte(String codigoMunicioOcorrenciaFatoGeradorICMSTransporte) {
        DFStringValidador.exatamente7N(codigoMunicioOcorrenciaFatoGeradorICMSTransporte, "Codigo Municipio Ocorrencia Fato Gerador ICMS Transporte");
        this.codigoMunicipioOcorrenciaFatoGeradorICMSTransporte = codigoMunicioOcorrenciaFatoGeradorICMSTransporte;
    }

    public String getValorServico() {
        return this.valorServico;
    }

    public String getBcRetencaoICMS() {
        return this.bcRetencaoICMS;
    }

    public String getAliquotaRetencao() {
        return this.aliquotaRetencao;
    }

    public String getValorICMSRetido() {
        return this.valorICMSRetido;
    }

    public Integer getCfop() {
        return this.cfop;
    }

    public String getCodigoMunicipioOcorrenciaFatoGeradorICMSTransporte() {
        return this.codigoMunicipioOcorrenciaFatoGeradorICMSTransporte;
    }
}

