/*
 * Decompiled with CFR 0.152.
 */
package com.fincatto.documentofiscal.nfe310.utils;

import com.fincatto.documentofiscal.DFAmbiente;
import com.fincatto.documentofiscal.nfe.NFeConfig;
import com.fincatto.documentofiscal.nfe310.classes.nota.NFNota;
import java.math.BigInteger;
import java.nio.charset.Charset;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import org.apache.commons.lang3.StringUtils;

public class NFGeraQRCode {
    private final NFNota nota;
    private final NFeConfig config;

    public NFGeraQRCode(NFNota nota, NFeConfig config) {
        this.nota = nota;
        this.config = config;
    }

    public String getQRCode() throws NoSuchAlgorithmException {
        String url;
        String string = url = this.config.getAmbiente().equals((Object)DFAmbiente.PRODUCAO) ? this.nota.getInfo().getIdentificacao().getUf().getQrCodeProducao() : this.nota.getInfo().getIdentificacao().getUf().getQrCodeHomologacao();
        if (StringUtils.isBlank((CharSequence)url)) {
            throw new IllegalArgumentException("URL para consulta do QRCode nao informada para uf " + (Object)((Object)this.nota.getInfo().getIdentificacao().getUf()) + "!");
        }
        if (StringUtils.isBlank((CharSequence)this.config.getCodigoSegurancaContribuinte())) {
            throw new IllegalArgumentException("CSC nao informado nas configuracoes!");
        }
        if (this.config.getCodigoSegurancaContribuinteID() == null || this.config.getCodigoSegurancaContribuinteID() == 0) {
            throw new IllegalArgumentException("IdCSC nao informado nas configuracoes!");
        }
        ZonedDateTime dt = this.nota.getInfo().getIdentificacao().getDataHoraEmissao();
        String dtf = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ssXXX").format(dt);
        String cpfj = this.nota.getInfo().getDestinatario() == null ? null : this.nota.getInfo().getDestinatario().getCpfj();
        StringBuilder parametros = new StringBuilder();
        parametros.append("chNFe=").append(this.nota.getInfo().getChaveAcesso()).append("&");
        parametros.append("nVersao=100").append("&");
        parametros.append("tpAmb=").append(this.config.getAmbiente().getCodigo()).append("&");
        if (StringUtils.isNotBlank((CharSequence)cpfj)) {
            parametros.append("cDest=").append(cpfj).append("&");
        }
        parametros.append("dhEmi=").append(NFGeraQRCode.toHex(dtf)).append("&");
        parametros.append("vNF=").append(this.nota.getInfo().getTotal().getIcmsTotal().getValorTotalNFe()).append("&");
        parametros.append("vICMS=").append(this.nota.getInfo().getTotal().getIcmsTotal().getValorTotalICMS()).append("&");
        parametros.append("digVal=").append(NFGeraQRCode.toHex(this.nota.getAssinatura().getSignedInfo().getReference().getDigestValue())).append("&");
        parametros.append("cIdToken=").append(String.format("%06d", this.config.getCodigoSegurancaContribuinteID()));
        return url + "?" + parametros.toString() + "&cHashQRCode=" + NFGeraQRCode.createHash(parametros.toString(), this.config.getCodigoSegurancaContribuinte());
    }

    public static String createHash(String campos, String csc) throws NoSuchAlgorithmException {
        return NFGeraQRCode.sha1(campos + csc);
    }

    public static String toHex(String arg) {
        return String.format("%040x", new BigInteger(1, arg.getBytes(Charset.forName("UTF-8"))));
    }

    public static String sha1(String input) throws NoSuchAlgorithmException {
        StringBuilder sb = new StringBuilder();
        for (byte element : MessageDigest.getInstance("SHA1").digest(input.getBytes(Charset.forName("UTF-8")))) {
            sb.append(Integer.toString((element & 0xFF) + 256, 16).substring(1));
        }
        return sb.toString();
    }
}

