/*
 * Decompiled with CFR 0.152.
 */
package com.fincatto.documentofiscal.nfe310.utils;

import java.util.Objects;
import org.apache.commons.lang3.StringUtils;

public class NFVerificaChave {
    private final String chave;

    public NFVerificaChave(String chave) {
        this.chave = chave;
    }

    public Integer calculaDV() {
        char[] valores = this.chaveAcessoSemDV().toCharArray();
        int[] valoresInt = new int[]{2, 3, 4, 5, 6, 7, 8, 9};
        int indice = 0;
        int soma = 0;
        for (int i = valores.length; i > 0; --i) {
            if (indice >= valoresInt.length) {
                indice = 0;
            }
            int valorTemp = Integer.parseInt(String.valueOf(valores[i - 1]));
            int multTemp = valoresInt[indice++];
            soma += valorTemp * multTemp;
        }
        int dv = 11 - soma % 11;
        return dv == 11 || dv == 10 ? 0 : dv;
    }

    private String chaveAcessoSemDV() {
        return StringUtils.substring((String)this.chave, (int)0, (int)43);
    }

    private Integer getChaveAcessoDV() {
        return Integer.valueOf(StringUtils.substring((String)this.chave, (int)43, (int)45));
    }

    public boolean isChaveValida() {
        if (StringUtils.length((CharSequence)this.chave) < 44) {
            return false;
        }
        return Objects.equals(this.getChaveAcessoDV(), this.calculaDV());
    }

    public static boolean isChaveValida(String chave) {
        NFVerificaChave nfVerificaChave = new NFVerificaChave(chave);
        return nfVerificaChave.isChaveValida();
    }
}

