/*
 * Decompiled with CFR 0.152.
 */
package com.fincatto.documentofiscal.nfe310.webservices;

import com.fincatto.documentofiscal.DFLog;
import com.fincatto.documentofiscal.DFUnidadeFederativa;
import com.fincatto.documentofiscal.nfe.NFeConfig;
import com.fincatto.documentofiscal.nfe310.classes.NFAutorizador31;
import com.fincatto.documentofiscal.nfe310.classes.cadastro.NFConsultaCadastro;
import com.fincatto.documentofiscal.nfe310.classes.cadastro.NFInfoConsultaCadastro;
import com.fincatto.documentofiscal.nfe310.classes.cadastro.NFRetornoConsultaCadastro;
import com.fincatto.documentofiscal.nfe310.webservices.gerado.CadConsultaCadastro2Stub;
import java.rmi.RemoteException;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.util.AXIOMUtil;

class WSConsultaCadastro
implements DFLog {
    private static final String NOME_SERVICO = "CONS-CAD";
    private static final String VERSAO_SERVICO = "2.00";
    private final NFeConfig config;

    WSConsultaCadastro(NFeConfig config) {
        this.config = config;
    }

    NFRetornoConsultaCadastro consultaCadastro(String cnpj, DFUnidadeFederativa uf) throws Exception {
        NFConsultaCadastro dadosConsulta = this.getDadosConsulta(cnpj, uf);
        String xmlConsulta = dadosConsulta.toString();
        this.getLogger().debug(xmlConsulta);
        OMElement omElementConsulta = AXIOMUtil.stringToOM((String)xmlConsulta);
        OMElement resultado = this.efetuaConsulta(uf, omElementConsulta);
        this.getLogger().debug(resultado.toString());
        return (NFRetornoConsultaCadastro)this.config.getPersister().read(NFRetornoConsultaCadastro.class, resultado.toString());
    }

    private OMElement efetuaConsulta(DFUnidadeFederativa uf, OMElement omElementConsulta) throws RemoteException {
        CadConsultaCadastro2Stub.NfeCabecMsg cabec = new CadConsultaCadastro2Stub.NfeCabecMsg();
        cabec.setCUF(uf.getCodigoIbge());
        cabec.setVersaoDados(VERSAO_SERVICO);
        CadConsultaCadastro2Stub.NfeCabecMsgE cabecE = new CadConsultaCadastro2Stub.NfeCabecMsgE();
        cabecE.setNfeCabecMsg(cabec);
        CadConsultaCadastro2Stub.NfeDadosMsg nfeDadosMsg = new CadConsultaCadastro2Stub.NfeDadosMsg();
        nfeDadosMsg.setExtraElement(omElementConsulta);
        NFAutorizador31 autorizador = NFAutorizador31.valueOfCodigoUF(uf);
        if (autorizador == null) {
            throw new IllegalStateException(String.format("UF %s nao possui autorizador para este servico", uf.getDescricao()));
        }
        return new CadConsultaCadastro2Stub(autorizador.getConsultaCadastro(this.config.getAmbiente()), this.config).consultaCadastro2(nfeDadosMsg, cabecE).getExtraElement();
    }

    private NFConsultaCadastro getDadosConsulta(String cnpj, DFUnidadeFederativa uf) {
        NFConsultaCadastro consulta = new NFConsultaCadastro();
        consulta.setVersao(VERSAO_SERVICO);
        consulta.setConsultaCadastro(new NFInfoConsultaCadastro());
        consulta.getConsultaCadastro().setCnpj(cnpj);
        consulta.getConsultaCadastro().setServico(NOME_SERVICO);
        consulta.getConsultaCadastro().setUf(uf.getCodigo());
        return consulta;
    }
}

