/*
 * Decompiled with CFR 0.152.
 */
package com.fincatto.documentofiscal.nfe310.webservices;

import com.fincatto.documentofiscal.DFLog;
import com.fincatto.documentofiscal.DFModelo;
import com.fincatto.documentofiscal.nfe.NFeConfig;
import com.fincatto.documentofiscal.nfe310.classes.NFAutorizador31;
import com.fincatto.documentofiscal.nfe310.classes.evento.inutilizacao.NFEnviaEventoInutilizacao;
import com.fincatto.documentofiscal.nfe310.classes.evento.inutilizacao.NFEventoInutilizacaoDados;
import com.fincatto.documentofiscal.nfe310.classes.evento.inutilizacao.NFRetornoEventoInutilizacao;
import com.fincatto.documentofiscal.nfe310.webservices.gerado.NfeInutilizacao2Stub;
import com.fincatto.documentofiscal.utils.DFAssinaturaDigital;
import java.math.BigDecimal;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.util.AXIOMUtil;
import org.apache.commons.lang3.StringUtils;

class WSInutilizacao
implements DFLog {
    private static final String VERSAO_SERVICO = "3.10";
    private static final String NOME_SERVICO = "INUTILIZAR";
    private final NFeConfig config;

    WSInutilizacao(NFeConfig config) {
        this.config = config;
    }

    NFRetornoEventoInutilizacao inutilizaNotaAssinada(String eventoAssinadoXml, DFModelo modelo) throws Exception {
        OMElement omElementResult = this.efetuaInutilizacao(eventoAssinadoXml, modelo);
        return (NFRetornoEventoInutilizacao)this.config.getPersister().read(NFRetornoEventoInutilizacao.class, omElementResult.toString());
    }

    NFRetornoEventoInutilizacao inutilizaNota(int anoInutilizacaoNumeracao, String cnpjEmitente, String serie, String numeroInicial, String numeroFinal, String justificativa, DFModelo modelo) throws Exception {
        String inutilizacaoXML = this.geraDadosInutilizacao(anoInutilizacaoNumeracao, cnpjEmitente, serie, numeroInicial, numeroFinal, justificativa, modelo).toString();
        String inutilizacaoXMLAssinado = new DFAssinaturaDigital(this.config).assinarDocumento(inutilizacaoXML);
        OMElement omElementResult = this.efetuaInutilizacao(inutilizacaoXMLAssinado, modelo);
        return (NFRetornoEventoInutilizacao)this.config.getPersister().read(NFRetornoEventoInutilizacao.class, omElementResult.toString());
    }

    private OMElement efetuaInutilizacao(String inutilizacaoXMLAssinado, DFModelo modelo) throws Exception {
        NfeInutilizacao2Stub.NfeCabecMsg cabecalho = new NfeInutilizacao2Stub.NfeCabecMsg();
        cabecalho.setCUF(this.config.getCUF().getCodigoIbge());
        cabecalho.setVersaoDados(VERSAO_SERVICO);
        NfeInutilizacao2Stub.NfeCabecMsgE cabecalhoE = new NfeInutilizacao2Stub.NfeCabecMsgE();
        cabecalhoE.setNfeCabecMsg(cabecalho);
        NfeInutilizacao2Stub.NfeDadosMsg dados = new NfeInutilizacao2Stub.NfeDadosMsg();
        OMElement omElement = AXIOMUtil.stringToOM((String)inutilizacaoXMLAssinado);
        this.getLogger().debug(omElement.toString());
        dados.setExtraElement(omElement);
        NFAutorizador31 autorizador = NFAutorizador31.valueOfCodigoUF(this.config.getCUF());
        String urlWebService = DFModelo.NFE.equals((Object)modelo) ? autorizador.getNfeInutilizacao(this.config.getAmbiente()) : autorizador.getNfceInutilizacao(this.config.getAmbiente());
        NfeInutilizacao2Stub.NfeInutilizacaoNF2Result nf2Result = new NfeInutilizacao2Stub(urlWebService, this.config).nfeInutilizacaoNF2(dados, cabecalhoE);
        OMElement dadosRetorno = nf2Result.getExtraElement();
        this.getLogger().debug(dadosRetorno.toString());
        return dadosRetorno;
    }

    private NFEnviaEventoInutilizacao geraDadosInutilizacao(int anoInutilizacaoNumeracao, String cnpjEmitente, String serie, String numeroInicial, String numeroFinal, String justificativa, DFModelo modelo) {
        NFEnviaEventoInutilizacao inutilizacao = new NFEnviaEventoInutilizacao();
        NFEventoInutilizacaoDados dados = new NFEventoInutilizacaoDados();
        dados.setAmbiente(this.config.getAmbiente());
        dados.setAno(anoInutilizacaoNumeracao);
        dados.setCnpj(cnpjEmitente);
        dados.setJustificativa(justificativa);
        dados.setModeloDocumentoFiscal(modelo.getCodigo());
        dados.setNomeServico(NOME_SERVICO);
        dados.setNumeroNFInicial(numeroInicial);
        dados.setNumeroNFFinal(numeroFinal);
        dados.setSerie(serie);
        dados.setUf(this.config.getCUF());
        String numeroInicialTamanhoMaximo = StringUtils.leftPad((String)numeroInicial, (int)9, (String)"0");
        String numeroFinalTamanhoMaximo = StringUtils.leftPad((String)numeroFinal, (int)9, (String)"0");
        String serieTamanhoMaximo = StringUtils.leftPad((String)serie, (int)3, (String)"0");
        dados.setIdentificador("ID" + this.config.getCUF().getCodigoIbge() + anoInutilizacaoNumeracao + cnpjEmitente + modelo.getCodigo() + serieTamanhoMaximo + numeroInicialTamanhoMaximo + numeroFinalTamanhoMaximo);
        inutilizacao.setVersao(new BigDecimal(VERSAO_SERVICO));
        inutilizacao.setDados(dados);
        return inutilizacao;
    }
}

