/*
 * Decompiled with CFR 0.152.
 */
package com.fincatto.documentofiscal.nfe310.webservices;

import com.fincatto.documentofiscal.DFLog;
import com.fincatto.documentofiscal.DFModelo;
import com.fincatto.documentofiscal.nfe.NFeConfig;
import com.fincatto.documentofiscal.nfe310.classes.NFAutorizador31;
import com.fincatto.documentofiscal.nfe310.classes.lote.envio.NFLoteEnvio;
import com.fincatto.documentofiscal.nfe310.classes.lote.envio.NFLoteEnvioRetorno;
import com.fincatto.documentofiscal.nfe310.classes.lote.envio.NFLoteEnvioRetornoDados;
import com.fincatto.documentofiscal.nfe310.classes.nota.NFNota;
import com.fincatto.documentofiscal.nfe310.classes.nota.NFNotaInfoSuplementar;
import com.fincatto.documentofiscal.nfe310.utils.NFGeraChave;
import com.fincatto.documentofiscal.nfe310.utils.NFGeraQRCode;
import com.fincatto.documentofiscal.nfe310.webservices.gerado.NfeAutorizacaoStub;
import com.fincatto.documentofiscal.utils.DFAssinaturaDigital;
import com.fincatto.documentofiscal.validadores.DFXMLValidador;
import java.io.StringReader;
import java.util.Iterator;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.impl.builder.StAXOMBuilder;
import org.apache.commons.lang3.StringUtils;

class WSLoteEnvio
implements DFLog {
    private static final String NFE_ELEMENTO = "NFe";
    private final NFeConfig config;

    WSLoteEnvio(NFeConfig config) {
        this.config = config;
    }

    NFLoteEnvioRetorno enviaLoteAssinado(String loteAssinadoXml, DFModelo modelo) throws Exception {
        return this.comunicaLote(loteAssinadoXml, modelo);
    }

    NFLoteEnvioRetornoDados enviaLote(NFLoteEnvio lote) throws Exception {
        NFLoteEnvio loteAssinado = this.getLoteAssinado(lote);
        NFLoteEnvioRetorno loteEnvioRetorno = this.comunicaLote(loteAssinado.toString(), loteAssinado.getNotas().get(0).getInfo().getIdentificacao().getModelo());
        return new NFLoteEnvioRetornoDados(loteEnvioRetorno, loteAssinado);
    }

    NFLoteEnvio getLoteAssinado(NFLoteEnvio lote) throws Exception {
        for (NFNota nota : lote.getNotas()) {
            NFGeraChave geraChave = new NFGeraChave(nota);
            nota.getInfo().getIdentificacao().setCodigoRandomico((String)StringUtils.defaultIfBlank((CharSequence)nota.getInfo().getIdentificacao().getCodigoRandomico(), (CharSequence)geraChave.geraCodigoRandomico()));
            nota.getInfo().getIdentificacao().setDigitoVerificador(geraChave.getDV());
            nota.getInfo().setIdentificador(geraChave.getChaveAcesso());
        }
        String documentoAssinado = new DFAssinaturaDigital(this.config).assinarDocumento(lote.toString());
        NFLoteEnvio loteAssinado = (NFLoteEnvio)this.config.getPersister().read(NFLoteEnvio.class, documentoAssinado);
        int qtdNF = 0;
        int qtdNFC = 0;
        block5: for (NFNota nota : loteAssinado.getNotas()) {
            switch (nota.getInfo().getIdentificacao().getModelo()) {
                case NFE: {
                    ++qtdNF;
                    continue block5;
                }
                case NFCE: {
                    NFGeraQRCode geraQRCode = new NFGeraQRCode(nota, this.config);
                    nota.setInfoSuplementar(new NFNotaInfoSuplementar());
                    nota.getInfoSuplementar().setQrCode(geraQRCode.getQRCode());
                    ++qtdNFC;
                    continue block5;
                }
            }
            throw new IllegalArgumentException(String.format("Modelo de nota desconhecida: %s", new Object[]{nota.getInfo().getIdentificacao().getModelo()}));
        }
        if (qtdNF > 0 && qtdNFC > 0) {
            throw new IllegalArgumentException("Lote contendo notas de modelos diferentes!");
        }
        return loteAssinado;
    }

    private NFLoteEnvioRetorno comunicaLote(String loteAssinadoXml, DFModelo modelo) throws Exception {
        String endpoint;
        DFXMLValidador.validaLote(loteAssinadoXml);
        OMElement omElement = this.nfeToOMElement(loteAssinadoXml);
        NfeAutorizacaoStub.NfeDadosMsg dados = new NfeAutorizacaoStub.NfeDadosMsg();
        dados.setExtraElement(omElement);
        NfeAutorizacaoStub.NfeCabecMsgE cabecalhoSOAP = this.getCabecalhoSOAP();
        this.getLogger().debug(omElement.toString());
        NFAutorizador31 autorizador = NFAutorizador31.valueOfTipoEmissao(this.config.getTipoEmissao(), this.config.getCUF());
        String string = endpoint = DFModelo.NFE.equals((Object)modelo) ? autorizador.getNfeAutorizacao(this.config.getAmbiente()) : autorizador.getNfceAutorizacao(this.config.getAmbiente());
        if (endpoint == null) {
            throw new IllegalArgumentException("Nao foi possivel encontrar URL para Autorizacao " + modelo.name() + ", autorizador " + autorizador.name());
        }
        NfeAutorizacaoStub.NfeAutorizacaoLoteResult autorizacaoLoteResult = new NfeAutorizacaoStub(endpoint, this.config).nfeAutorizacaoLote(dados, cabecalhoSOAP);
        NFLoteEnvioRetorno loteEnvioRetorno = (NFLoteEnvioRetorno)this.config.getPersister().read(NFLoteEnvioRetorno.class, autorizacaoLoteResult.getExtraElement().toString());
        this.getLogger().debug(loteEnvioRetorno.toString());
        return loteEnvioRetorno;
    }

    private NfeAutorizacaoStub.NfeCabecMsgE getCabecalhoSOAP() {
        NfeAutorizacaoStub.NfeCabecMsg cabecalho = new NfeAutorizacaoStub.NfeCabecMsg();
        cabecalho.setCUF(this.config.getCUF().getCodigoIbge());
        cabecalho.setVersaoDados(this.config.getVersao());
        NfeAutorizacaoStub.NfeCabecMsgE cabecalhoSOAP = new NfeAutorizacaoStub.NfeCabecMsgE();
        cabecalhoSOAP.setNfeCabecMsg(cabecalho);
        return cabecalhoSOAP;
    }

    private OMElement nfeToOMElement(String documento) throws XMLStreamException {
        XMLInputFactory factory = XMLInputFactory.newInstance();
        factory.setProperty("javax.xml.stream.isCoalescing", false);
        XMLStreamReader reader = factory.createXMLStreamReader(new StringReader(documento));
        StAXOMBuilder builder = new StAXOMBuilder(reader);
        OMElement ome = builder.getDocumentElement();
        Iterator children = ome.getChildrenWithLocalName(NFE_ELEMENTO);
        while (children.hasNext()) {
            OMElement omElement = (OMElement)children.next();
            if (omElement == null || !NFE_ELEMENTO.equals(omElement.getLocalName())) continue;
            omElement.addAttribute("xmlns", "http://www.portalfiscal.inf.br/nfe", null);
        }
        return ome;
    }
}

