/*
 * Decompiled with CFR 0.152.
 */
package com.fincatto.documentofiscal.nfe310.webservices;

import com.fincatto.documentofiscal.DFLog;
import com.fincatto.documentofiscal.DFModelo;
import com.fincatto.documentofiscal.DFUnidadeFederativa;
import com.fincatto.documentofiscal.nfe.NFeConfig;
import com.fincatto.documentofiscal.nfe310.classes.NFAutorizador31;
import com.fincatto.documentofiscal.nfe310.classes.nota.consulta.NFNotaConsulta;
import com.fincatto.documentofiscal.nfe310.classes.nota.consulta.NFNotaConsultaRetorno;
import com.fincatto.documentofiscal.nfe310.parsers.NotaFiscalChaveParser;
import com.fincatto.documentofiscal.nfe310.webservices.gerado.NfeConsulta2Stub;
import com.fincatto.documentofiscal.nfe310.webservices.nota.consulta.NfeConsultaStub;
import java.math.BigDecimal;
import java.rmi.RemoteException;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.util.AXIOMUtil;

class WSNotaConsulta
implements DFLog {
    private static final String NOME_SERVICO = "CONSULTAR";
    private static final String VERSAO_SERVICO = "3.10";
    private final NFeConfig config;

    WSNotaConsulta(NFeConfig config) {
        this.config = config;
    }

    NFNotaConsultaRetorno consultaNota(String chaveDeAcesso) throws Exception {
        OMElement omElementConsulta = AXIOMUtil.stringToOM((String)this.gerarDadosConsulta(chaveDeAcesso).toString());
        this.getLogger().debug(omElementConsulta.toString());
        OMElement omElementRetorno = this.efetuaConsulta(omElementConsulta, chaveDeAcesso);
        this.getLogger().debug(omElementRetorno.toString());
        return (NFNotaConsultaRetorno)this.config.getPersister().read(NFNotaConsultaRetorno.class, omElementRetorno.toString());
    }

    private OMElement efetuaConsulta(OMElement omElementConsulta, String chaveDeAcesso) throws Exception {
        boolean consultaNFeBahia;
        NotaFiscalChaveParser notaFiscalChaveParser = new NotaFiscalChaveParser(chaveDeAcesso);
        boolean bl = consultaNFeBahia = DFUnidadeFederativa.BA.equals((Object)notaFiscalChaveParser.getNFUnidadeFederativa()) && DFModelo.NFE.equals((Object)notaFiscalChaveParser.getModelo());
        if (consultaNFeBahia) {
            return this.efetuaConsultaBA(omElementConsulta, chaveDeAcesso);
        }
        return this.efetuaConsultaSVRS(omElementConsulta, chaveDeAcesso);
    }

    private OMElement efetuaConsultaSVRS(OMElement omElementConsulta, String chaveDeAcesso) throws RemoteException {
        String endpoint;
        NotaFiscalChaveParser notaFiscalChaveParser = new NotaFiscalChaveParser(chaveDeAcesso);
        NfeConsulta2Stub.NfeCabecMsg cabec = new NfeConsulta2Stub.NfeCabecMsg();
        cabec.setCUF(notaFiscalChaveParser.getNFUnidadeFederativa().getCodigoIbge());
        cabec.setVersaoDados(VERSAO_SERVICO);
        NfeConsulta2Stub.NfeCabecMsgE cabecE = new NfeConsulta2Stub.NfeCabecMsgE();
        cabecE.setNfeCabecMsg(cabec);
        NfeConsulta2Stub.NfeDadosMsg dados = new NfeConsulta2Stub.NfeDadosMsg();
        dados.setExtraElement(omElementConsulta);
        NFAutorizador31 autorizador = NFAutorizador31.valueOfChaveAcesso(chaveDeAcesso);
        String string = endpoint = DFModelo.NFCE.equals((Object)notaFiscalChaveParser.getModelo()) ? autorizador.getNfceConsultaProtocolo(this.config.getAmbiente()) : autorizador.getNfeConsultaProtocolo(this.config.getAmbiente());
        if (endpoint == null) {
            throw new IllegalArgumentException("Nao foi possivel encontrar URL para ConsultaProtocolo " + notaFiscalChaveParser.getModelo().name() + ", autorizador " + autorizador.name());
        }
        NfeConsulta2Stub.NfeConsultaNF2Result consultaNF2Result = new NfeConsulta2Stub(endpoint, this.config).nfeConsultaNF2(dados, cabecE);
        return consultaNF2Result.getExtraElement();
    }

    private OMElement efetuaConsultaBA(OMElement omElementConsulta, String chaveDeAcesso) throws RemoteException {
        String endpoint;
        NotaFiscalChaveParser notaFiscalChaveParser = new NotaFiscalChaveParser(chaveDeAcesso);
        NfeConsultaStub.NfeCabecMsg cabec = new NfeConsultaStub.NfeCabecMsg();
        cabec.setCUF(notaFiscalChaveParser.getNFUnidadeFederativa().getCodigoIbge());
        cabec.setVersaoDados(VERSAO_SERVICO);
        NfeConsultaStub.NfeCabecMsgE cabecE = new NfeConsultaStub.NfeCabecMsgE();
        cabecE.setNfeCabecMsg(cabec);
        NfeConsultaStub.NfeDadosMsg dados = new NfeConsultaStub.NfeDadosMsg();
        dados.setExtraElement(omElementConsulta);
        NFAutorizador31 autorizador = NFAutorizador31.valueOfChaveAcesso(chaveDeAcesso);
        String string = endpoint = DFModelo.NFCE.equals((Object)notaFiscalChaveParser.getModelo()) ? autorizador.getNfceConsultaProtocolo(this.config.getAmbiente()) : autorizador.getNfeConsultaProtocolo(this.config.getAmbiente());
        if (endpoint == null) {
            throw new IllegalArgumentException("Nao foi possivel encontrar URL para ConsultaProtocolo " + notaFiscalChaveParser.getModelo().name() + ", autorizador " + autorizador.name());
        }
        NfeConsultaStub.NfeConsultaNFResult consultaNFResult = new NfeConsultaStub(endpoint, this.config).nfeConsultaNF(dados, cabecE);
        return consultaNFResult.getExtraElement();
    }

    private NFNotaConsulta gerarDadosConsulta(String chaveDeAcesso) {
        NFNotaConsulta notaConsulta = new NFNotaConsulta();
        notaConsulta.setAmbiente(this.config.getAmbiente());
        notaConsulta.setChave(chaveDeAcesso);
        notaConsulta.setServico(NOME_SERVICO);
        notaConsulta.setVersao(new BigDecimal(VERSAO_SERVICO));
        return notaConsulta;
    }
}

