/*
 * Decompiled with CFR 0.152.
 */
package com.fincatto.documentofiscal.nfe310.webservices;

import com.fincatto.documentofiscal.DFLog;
import com.fincatto.documentofiscal.nfe.NFeConfig;
import com.fincatto.documentofiscal.nfe310.classes.NFAutorizador31;
import com.fincatto.documentofiscal.nfe310.classes.evento.downloadnf.NFDownloadNFe;
import com.fincatto.documentofiscal.nfe310.classes.evento.downloadnf.NFDownloadNFeRetorno;
import com.fincatto.documentofiscal.nfe310.webservices.downloadnf.NfeDownloadNFStub;
import java.math.BigDecimal;
import java.rmi.RemoteException;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.util.AXIOMUtil;

class WSNotaDownload
implements DFLog {
    private static final BigDecimal VERSAO_LEIAUTE = new BigDecimal("1.00");
    private static final String NOME_SERVICO = "DOWNLOAD NFE";
    private final NFeConfig config;

    WSNotaDownload(NFeConfig config) {
        this.config = config;
    }

    NFDownloadNFeRetorno downloadNota(String cnpj, String chave) throws Exception {
        OMElement omElementConsulta = AXIOMUtil.stringToOM((String)this.gerarDadosDownloadNF(cnpj, chave).toString());
        this.getLogger().debug(omElementConsulta.toString());
        OMElement omElementRetorno = this.efetuaDownloadNF(omElementConsulta);
        this.getLogger().debug(omElementRetorno.toString());
        return (NFDownloadNFeRetorno)this.config.getPersister().read(NFDownloadNFeRetorno.class, omElementRetorno.toString());
    }

    private OMElement efetuaDownloadNF(OMElement omElementConsulta) throws RemoteException {
        NfeDownloadNFStub.NfeCabecMsg cabec = new NfeDownloadNFStub.NfeCabecMsg();
        cabec.setCUF(this.config.getCUF().getCodigoIbge());
        cabec.setVersaoDados(VERSAO_LEIAUTE.toPlainString());
        NfeDownloadNFStub.NfeCabecMsgE cabecE = new NfeDownloadNFStub.NfeCabecMsgE();
        cabecE.setNfeCabecMsg(cabec);
        NfeDownloadNFStub.NfeDadosMsg dados = new NfeDownloadNFStub.NfeDadosMsg();
        dados.setExtraElement(omElementConsulta);
        NFAutorizador31 autorizador = NFAutorizador31.valueOfCodigoUF(this.config.getCUF());
        String endpoint = autorizador.getNfeDownloadNF(this.config.getAmbiente());
        if (endpoint == null) {
            throw new IllegalArgumentException("Nao foi possivel encontrar URL para DownloadNF, autorizador " + autorizador.name());
        }
        NfeDownloadNFStub.NfeDownloadNFResult nfeDownloadNFResult = new NfeDownloadNFStub(endpoint, this.config).nfeDownloadNF(dados, cabecE);
        return nfeDownloadNFResult.getExtraElement();
    }

    private NFDownloadNFe gerarDadosDownloadNF(String cnpj, String chave) {
        NFDownloadNFe nfDownloadNFe = new NFDownloadNFe();
        nfDownloadNFe.setVersao(VERSAO_LEIAUTE.toPlainString());
        nfDownloadNFe.setAmbiente(this.config.getAmbiente());
        nfDownloadNFe.setServico(NOME_SERVICO);
        nfDownloadNFe.setCnpj(cnpj);
        nfDownloadNFe.setChave(chave);
        return nfDownloadNFe;
    }
}

