/*
 * Decompiled with CFR 0.152.
 */
package com.fincatto.documentofiscal.nfe400.classes;

import org.apache.commons.lang3.StringUtils;

public enum NFNotaInfoVeiculoCor {
    AMARELA("01", "Amarela"),
    AZUL("02", "Azul"),
    BEGE("03", "Bege"),
    BRANCA("04", "Branca"),
    CINZA("05", "Cinza"),
    DOURADA("06", "Dourada"),
    GRENA("07", "Gren\u00e1"),
    LARANJA("08", "Laranja"),
    MARROM("09", "Marrom"),
    PRATA("10", "Prata"),
    PRETA("11", "Preta"),
    ROSA("12", "Rosa"),
    ROXA("13", "Roxa"),
    VERDE("14", "Verde"),
    VERMELHA("15", "Vermelha"),
    FANTASIA("16", "Fantasia");

    private final String codigo;
    private final String descricao;

    private NFNotaInfoVeiculoCor(String codigo, String descricao) {
        this.codigo = StringUtils.leftPad((String)codigo, (int)2, (String)"0");
        this.descricao = descricao;
    }

    public String getCodigo() {
        return this.codigo;
    }

    public static NFNotaInfoVeiculoCor valueOfCodigo(String codigo) {
        for (NFNotaInfoVeiculoCor veiculoCor : NFNotaInfoVeiculoCor.values()) {
            if (!veiculoCor.getCodigo().equals(StringUtils.leftPad((String)codigo, (int)2, (String)"0"))) continue;
            return veiculoCor;
        }
        return null;
    }

    public String toString() {
        return this.codigo + " - " + this.descricao;
    }
}

