/*
 * Decompiled with CFR 0.152.
 */
package com.fincatto.documentofiscal.nfe400.classes.nota;

public enum NFMeioPagamento {
    DINHEIRO("01", "Dinheiro"),
    CHEQUE("02", "Cheque"),
    CARTAO_CREDITO("03", "Cart\u00e3o de cr\u00e9dito"),
    CARTAO_DEBITO("04", "Cart\u00e3o de d\u00e9bito"),
    CARTAO_LOJA("05", "Cart\u00e3o da loja"),
    VALE_ALIMENTACAO("10", "Vale alimenta\u00e7\u00e3o"),
    VALE_REFEICAO("11", "Vale refei\u00e7\u00e3o"),
    VALE_PRESENTE("12", "Vale presente"),
    VALE_COMBUSTIVEL("13", "Vale combust\u00edvel"),
    DUPLICATA_MERCANTIL("14", "Duplicata mercantil"),
    BOLETO_BANCARIO("15", "Boleto bancario"),
    DEPOSITO_BANCARIO("16", "Deposito bancario"),
    PIX("17", "Pagamento Instantaneo (PIX)"),
    TRANSFERENCIA_BANCARIA("18", "Transferencia bancaria"),
    FIDELIDADE_CASHBACK("19", "Programa de fidelidade (Cashback)"),
    PIX_ESTATICO("20", "Pagamento Instantaneo (PIX Estatico)"),
    CREDITO_EM_LOJA("21", "Credito em Loja"),
    PAG_ELETRONICO_NAO_INF("22", "Pagamento Eletronico Nao Informado"),
    SEM_PAGAMENTO("90", "Sem pagamento"),
    OUTRO("99", "Outro");

    private final String codigo;
    private final String descricao;

    private NFMeioPagamento(String codigo, String descricao) {
        this.codigo = codigo;
        this.descricao = descricao;
    }

    public String getCodigo() {
        return this.codigo;
    }

    public static NFMeioPagamento valueOfCodigo(String codigo) {
        for (NFMeioPagamento formaPagamentoMoeda : NFMeioPagamento.values()) {
            if (!formaPagamentoMoeda.getCodigo().equals(codigo)) continue;
            return formaPagamentoMoeda;
        }
        return null;
    }

    public String toString() {
        return this.codigo + " - " + this.descricao;
    }

    public String getDescricao() {
        return this.descricao;
    }
}

