/*
 * Decompiled with CFR 0.152.
 */
package com.fincatto.documentofiscal.nfe400.classes.nota;

import com.fincatto.documentofiscal.DFAmbiente;
import com.fincatto.documentofiscal.DFBase;
import com.fincatto.documentofiscal.DFModelo;
import com.fincatto.documentofiscal.DFUnidadeFederativa;
import com.fincatto.documentofiscal.nfe.NFTipoEmissao;
import com.fincatto.documentofiscal.nfe400.classes.NFFinalidade;
import com.fincatto.documentofiscal.nfe400.classes.NFProcessoEmissor;
import com.fincatto.documentofiscal.nfe400.classes.NFTipo;
import com.fincatto.documentofiscal.nfe400.classes.NFTipoImpressao;
import com.fincatto.documentofiscal.nfe400.classes.nota.NFIdentificadorLocalDestinoOperacao;
import com.fincatto.documentofiscal.nfe400.classes.nota.NFIndicadorIntermediador;
import com.fincatto.documentofiscal.nfe400.classes.nota.NFIndicadorPresencaComprador;
import com.fincatto.documentofiscal.nfe400.classes.nota.NFInfoReferenciada;
import com.fincatto.documentofiscal.nfe400.classes.nota.NFOperacaoConsumidorFinal;
import com.fincatto.documentofiscal.validadores.DFIntegerValidador;
import com.fincatto.documentofiscal.validadores.DFListValidador;
import com.fincatto.documentofiscal.validadores.DFStringValidador;
import java.time.ZonedDateTime;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.simpleframework.xml.Element;
import org.simpleframework.xml.ElementList;

public class NFNotaInfoIdentificacao
extends DFBase {
    private static final long serialVersionUID = -2568396066960865875L;
    @Element(name="cUF")
    private DFUnidadeFederativa uf;
    @Element(name="cNF")
    private String codigoRandomico;
    @Element(name="natOp")
    private String naturezaOperacao;
    @Element(name="mod")
    private DFModelo modelo;
    @Element(name="serie")
    private String serie;
    @Element(name="nNF")
    private String numeroNota;
    @Element(name="dhEmi")
    private ZonedDateTime dataHoraEmissao;
    @Element(name="dhSaiEnt", required=false)
    private ZonedDateTime dataHoraSaidaOuEntrada;
    @Element(name="tpNF")
    private NFTipo tipo;
    @Element(name="idDest")
    private NFIdentificadorLocalDestinoOperacao identificadorLocalDestinoOperacao;
    @Element(name="cMunFG")
    private String codigoMunicipio;
    @Element(name="tpImp")
    private NFTipoImpressao tipoImpressao;
    @Element(name="tpEmis")
    private NFTipoEmissao tipoEmissao;
    @Element(name="cDV")
    private Integer digitoVerificador;
    @Element(name="tpAmb")
    private DFAmbiente ambiente;
    @Element(name="finNFe")
    private NFFinalidade finalidade;
    @Element(name="indFinal")
    private NFOperacaoConsumidorFinal operacaoConsumidorFinal;
    @Element(name="indPres")
    private NFIndicadorPresencaComprador indicadorPresencaComprador;
    @Element(name="indIntermed", required=false)
    private NFIndicadorIntermediador indIntermed;
    @Element(name="procEmi")
    private NFProcessoEmissor programaEmissor;
    @Element(name="verProc")
    private String versaoEmissor;
    @Element(name="dhCont", required=false)
    private ZonedDateTime dataHoraContigencia;
    @Element(name="xJust", required=false)
    private String justificativaEntradaContingencia;
    @ElementList(entry="NFref", inline=true, required=false)
    private List<NFInfoReferenciada> referenciadas;

    public void setUf(DFUnidadeFederativa uf) {
        this.uf = uf;
    }

    public void setCodigoRandomico(String codigoRandomico) {
        DFStringValidador.exatamente8(codigoRandomico, "Codigo Randomico");
        DFStringValidador.validaCodigoRandomico(codigoRandomico, "Codigo Randomico");
        if (StringUtils.isNotBlank((CharSequence)this.numeroNota) && StringUtils.equals((CharSequence)this.numeroNota.substring(1), (CharSequence)codigoRandomico)) {
            throw new IllegalStateException(String.format("N\u00famero da nota(%s) e c\u00f3digo(%s) n\u00e3o podem ser iguais", this.numeroNota.substring(1), codigoRandomico));
        }
        this.codigoRandomico = codigoRandomico;
    }

    public void setNaturezaOperacao(String naturezaOperacao) {
        DFStringValidador.tamanho60(naturezaOperacao, "Natureza da Operacao");
        this.naturezaOperacao = naturezaOperacao;
    }

    public void setModelo(DFModelo modelo) {
        this.modelo = modelo;
    }

    public void setSerie(String serie) {
        DFStringValidador.validador(serie, "Serie", 3, false, true);
        this.serie = serie;
    }

    public void setNumeroNota(String numeroNota) {
        DFStringValidador.tamanho9(numeroNota, "Numero da Nota");
        if (StringUtils.isNotBlank((CharSequence)this.codigoRandomico) && StringUtils.equals((CharSequence)numeroNota.substring(1), (CharSequence)this.codigoRandomico)) {
            throw new IllegalStateException(String.format("N\u00famero da nota(%s) e c\u00f3digo(%s) n\u00e3o podem ser iguais", numeroNota.substring(1), this.codigoRandomico));
        }
        this.numeroNota = numeroNota;
    }

    public void setDataHoraEmissao(ZonedDateTime dataEmissao) {
        this.dataHoraEmissao = dataEmissao;
    }

    public void setDataHoraSaidaOuEntrada(ZonedDateTime dataHoraSaidaOuEntrada) {
        this.dataHoraSaidaOuEntrada = dataHoraSaidaOuEntrada;
    }

    public void setTipo(NFTipo tipo) {
        this.tipo = tipo;
    }

    public void setCodigoMunicipio(String codigoMunicipio) {
        DFStringValidador.exatamente7N(codigoMunicipio, "Codigo Municipio");
        this.codigoMunicipio = codigoMunicipio;
    }

    public void setReferenciadas(List<NFInfoReferenciada> referenciadas) {
        DFListValidador.tamanho500(referenciadas, "Referenciadas");
        this.referenciadas = referenciadas;
    }

    public void setTipoImpressao(NFTipoImpressao tipoImpressao) {
        this.tipoImpressao = tipoImpressao;
    }

    public void setTipoEmissao(NFTipoEmissao tipoEmissao) {
        this.tipoEmissao = tipoEmissao;
    }

    public void setDigitoVerificador(Integer digitoVerificador) {
        DFIntegerValidador.exatamente1(digitoVerificador, "DV");
        this.digitoVerificador = digitoVerificador;
    }

    public void setAmbiente(DFAmbiente ambiente) {
        this.ambiente = ambiente;
    }

    public void setFinalidade(NFFinalidade finalidade) {
        this.finalidade = finalidade;
    }

    public void setProgramaEmissor(NFProcessoEmissor programaEmissor) {
        this.programaEmissor = programaEmissor;
    }

    public void setVersaoEmissor(String versaoEmissor) {
        DFStringValidador.tamanho20(versaoEmissor, "Versao Emissor");
        this.versaoEmissor = versaoEmissor;
    }

    public void setDataHoraContigencia(ZonedDateTime dataHoraContigencia) {
        this.dataHoraContigencia = dataHoraContigencia;
    }

    public void setJustificativaEntradaContingencia(String justificativaEntradaContingencia) {
        DFStringValidador.tamanho15a256(justificativaEntradaContingencia, "Justificativa Entrada Contingencia");
        this.justificativaEntradaContingencia = justificativaEntradaContingencia;
    }

    public void setIdentificadorLocalDestinoOperacao(NFIdentificadorLocalDestinoOperacao identificadorLocalDestinoOperacao) {
        this.identificadorLocalDestinoOperacao = identificadorLocalDestinoOperacao;
    }

    public void setOperacaoConsumidorFinal(NFOperacaoConsumidorFinal operacaoConsumidorFinal) {
        this.operacaoConsumidorFinal = operacaoConsumidorFinal;
    }

    public void setIndicadorPresencaComprador(NFIndicadorPresencaComprador indicadorPresencaComprador) {
        this.indicadorPresencaComprador = indicadorPresencaComprador;
    }

    public void setIndIntermed(NFIndicadorIntermediador indIntermed) {
        this.indIntermed = indIntermed;
    }

    public DFUnidadeFederativa getUf() {
        return this.uf;
    }

    public String getCodigoRandomico() {
        return this.codigoRandomico;
    }

    public String getNaturezaOperacao() {
        return this.naturezaOperacao;
    }

    public DFModelo getModelo() {
        return this.modelo;
    }

    public String getSerie() {
        return this.serie;
    }

    public String getNumeroNota() {
        return this.numeroNota;
    }

    public ZonedDateTime getDataHoraEmissao() {
        return this.dataHoraEmissao;
    }

    public ZonedDateTime getDataHoraSaidaOuEntrada() {
        return this.dataHoraSaidaOuEntrada;
    }

    public NFTipo getTipo() {
        return this.tipo;
    }

    public NFIdentificadorLocalDestinoOperacao getIdentificadorLocalDestinoOperacao() {
        return this.identificadorLocalDestinoOperacao;
    }

    public String getCodigoMunicipio() {
        return this.codigoMunicipio;
    }

    public NFTipoImpressao getTipoImpressao() {
        return this.tipoImpressao;
    }

    public NFTipoEmissao getTipoEmissao() {
        return this.tipoEmissao;
    }

    public Integer getDigitoVerificador() {
        return this.digitoVerificador;
    }

    public DFAmbiente getAmbiente() {
        return this.ambiente;
    }

    public NFFinalidade getFinalidade() {
        return this.finalidade;
    }

    public NFOperacaoConsumidorFinal getOperacaoConsumidorFinal() {
        return this.operacaoConsumidorFinal;
    }

    public NFIndicadorPresencaComprador getIndicadorPresencaComprador() {
        return this.indicadorPresencaComprador;
    }

    public NFIndicadorIntermediador getIndIntermed() {
        return this.indIntermed;
    }

    public NFProcessoEmissor getProgramaEmissor() {
        return this.programaEmissor;
    }

    public String getVersaoEmissor() {
        return this.versaoEmissor;
    }

    public ZonedDateTime getDataHoraContigencia() {
        return this.dataHoraContigencia;
    }

    public String getJustificativaEntradaContingencia() {
        return this.justificativaEntradaContingencia;
    }

    public List<NFInfoReferenciada> getReferenciadas() {
        return this.referenciadas;
    }
}

