/*
 * Decompiled with CFR 0.152.
 */
package com.fincatto.documentofiscal.nfe400.classes.nota;

import com.fincatto.documentofiscal.DFBase;
import com.fincatto.documentofiscal.nfe400.classes.nota.NFImpostoDevolvido;
import com.fincatto.documentofiscal.nfe400.classes.nota.NFNotaInfoItemImposto;
import com.fincatto.documentofiscal.nfe400.classes.nota.NFNotaInfoItemProduto;
import com.fincatto.documentofiscal.nfe400.classes.nota.NFNotaInfoObservacao;
import com.fincatto.documentofiscal.validadores.DFIntegerValidador;
import com.fincatto.documentofiscal.validadores.DFStringValidador;
import java.util.List;
import org.simpleframework.xml.Attribute;
import org.simpleframework.xml.Element;
import org.simpleframework.xml.ElementList;

public class NFNotaInfoItem
extends DFBase {
    private static final long serialVersionUID = 362646693945373643L;
    @Attribute(name="nItem")
    private Integer numeroItem;
    @Element(name="prod")
    private NFNotaInfoItemProduto produto;
    @Element(name="imposto")
    private NFNotaInfoItemImposto imposto;
    @Element(name="impostoDevol", required=false)
    private NFImpostoDevolvido impostoDevolvido;
    @Element(name="infAdProd", required=false)
    private String informacoesAdicionais;
    @ElementList(entry="obsCont", inline=true, required=false)
    private List<NFNotaInfoObservacao> observacoesContribuinte;
    @ElementList(entry="obsFisco", inline=true, required=false)
    private List<NFNotaInfoObservacao> observacoesFisco;

    public void setNumeroItem(Integer numeroItem) {
        DFIntegerValidador.tamanho3maximo990(numeroItem, "Numero do Item");
        this.numeroItem = numeroItem;
    }

    public void setInformacoesAdicionais(String informacoesAdicionais) {
        DFStringValidador.tamanho500(informacoesAdicionais, "Informacoes Adicionais do Item");
        this.informacoesAdicionais = informacoesAdicionais;
    }

    public void setProduto(NFNotaInfoItemProduto produto) {
        this.produto = produto;
    }

    public void setImposto(NFNotaInfoItemImposto imposto) {
        this.imposto = imposto;
    }

    public void setObservacoesContribuinte(List<NFNotaInfoObservacao> observacoesContribuinte) {
        this.observacoesContribuinte = observacoesContribuinte;
    }

    public void setObservacoesFisco(List<NFNotaInfoObservacao> observacoesFisco) {
        this.observacoesFisco = observacoesFisco;
    }

    public Integer getNumeroItem() {
        return this.numeroItem;
    }

    public NFNotaInfoItemProduto getProduto() {
        return this.produto;
    }

    public NFNotaInfoItemImposto getImposto() {
        return this.imposto;
    }

    public String getInformacoesAdicionais() {
        return this.informacoesAdicionais;
    }

    public NFImpostoDevolvido getImpostoDevolvido() {
        return this.impostoDevolvido;
    }

    public List<NFNotaInfoObservacao> getObservacoesContribuinte() {
        return this.observacoesContribuinte;
    }

    public List<NFNotaInfoObservacao> getObservacoesFisco() {
        return this.observacoesFisco;
    }

    public void setImpostoDevolvido(NFImpostoDevolvido impostoDevolvido) {
        this.impostoDevolvido = impostoDevolvido;
    }
}

