/*
 * Decompiled with CFR 0.152.
 */
package com.fincatto.documentofiscal.nfe400.classes.nota;

import com.fincatto.documentofiscal.DFBase;
import com.fincatto.documentofiscal.DFLog;
import com.fincatto.documentofiscal.nfe400.classes.nota.NFNotaInfoItemImpostoCOFINS;
import com.fincatto.documentofiscal.nfe400.classes.nota.NFNotaInfoItemImpostoCOFINSST;
import com.fincatto.documentofiscal.nfe400.classes.nota.NFNotaInfoItemImpostoICMS;
import com.fincatto.documentofiscal.nfe400.classes.nota.NFNotaInfoItemImpostoICMSUFDestino;
import com.fincatto.documentofiscal.nfe400.classes.nota.NFNotaInfoItemImpostoIPI;
import com.fincatto.documentofiscal.nfe400.classes.nota.NFNotaInfoItemImpostoISSQN;
import com.fincatto.documentofiscal.nfe400.classes.nota.NFNotaInfoItemImpostoImportacao;
import com.fincatto.documentofiscal.nfe400.classes.nota.NFNotaInfoItemImpostoPIS;
import com.fincatto.documentofiscal.nfe400.classes.nota.NFNotaInfoItemImpostoPISST;
import com.fincatto.documentofiscal.validadores.DFBigDecimalValidador;
import com.fincatto.documentofiscal.validadores.DFStringValidador;
import java.lang.reflect.InvocationTargetException;
import java.math.BigDecimal;
import org.simpleframework.xml.Element;

public class NFNotaInfoItemImposto
extends DFBase {
    private static final long serialVersionUID = 8579628067567740408L;
    @Element(name="vTotTrib", required=false)
    private String valorTotalTributos;
    @Element(name="ICMS", required=false)
    private NFNotaInfoItemImpostoICMS icms;
    @Element(name="IPI", required=false)
    private NFNotaInfoItemImpostoIPI ipi;
    @Element(name="II", required=false)
    private NFNotaInfoItemImpostoImportacao impostoImportacao;
    @Element(name="ISSQN", required=false)
    private NFNotaInfoItemImpostoISSQN issqn;
    @Element(name="PIS", required=false)
    private NFNotaInfoItemImpostoPIS pis;
    @Element(name="PISST", required=false)
    private NFNotaInfoItemImpostoPISST pisst;
    @Element(name="COFINS", required=false)
    private NFNotaInfoItemImpostoCOFINS cofins;
    @Element(name="COFINSST", required=false)
    private NFNotaInfoItemImpostoCOFINSST cofinsst;
    @Element(name="ICMSUFDest", required=false)
    private NFNotaInfoItemImpostoICMSUFDestino icmsUfDestino;

    public void setIcms(NFNotaInfoItemImpostoICMS icms) {
        if (this.issqn != null) {
            throw new IllegalStateException("ICMS, IPI e II sao mutuamente exclusivo com ISSQN");
        }
        try {
            DFStringValidador.validaPreenchimentoDeMargemValorAgregado(icms);
        }
        catch (IllegalAccessException e) {
            DFLog.getLogger(NFNotaInfoItemImposto.class).error("Erro ao validar preenchimento de Margem de Valor agregado", (Throwable)e);
        }
        catch (InvocationTargetException e) {
            DFLog.getLogger(NFNotaInfoItemImposto.class).error("Erro ao validar preenchimento de Margem de Valor agregado", (Throwable)e);
        }
        this.icms = icms;
    }

    public void setIpi(NFNotaInfoItemImpostoIPI ipi) {
        if (this.issqn != null) {
            throw new IllegalStateException("ICMS, IPI e II sao mutuamente exclusivo com ISSQN");
        }
        this.ipi = ipi;
    }

    public void setImpostoImportacao(NFNotaInfoItemImpostoImportacao impostoImportacao) {
        if (this.issqn != null) {
            throw new IllegalStateException("ICMS, IPI e II sao mutuamente exclusivo com ISSQN");
        }
        this.impostoImportacao = impostoImportacao;
    }

    public void setIssqn(NFNotaInfoItemImpostoISSQN issqn) {
        if (this.icms != null || this.ipi != null || this.impostoImportacao != null) {
            throw new IllegalStateException("ICMS, IPI e II sao mutuamente exclusivo com ISSQN");
        }
        this.issqn = issqn;
    }

    public void setPis(NFNotaInfoItemImpostoPIS pis) {
        this.pis = pis;
    }

    public void setPisst(NFNotaInfoItemImpostoPISST pisst) {
        this.pisst = pisst;
    }

    public void setCofins(NFNotaInfoItemImpostoCOFINS cofins) {
        this.cofins = cofins;
    }

    public void setCofinsst(NFNotaInfoItemImpostoCOFINSST cofinsst) {
        this.cofinsst = cofinsst;
    }

    public void setValorTotalTributos(BigDecimal valorTotalTributos) {
        this.valorTotalTributos = DFBigDecimalValidador.tamanho15Com2CasasDecimais(valorTotalTributos, "Valor Total Tributos");
    }

    public String getValorTotalTributos() {
        return this.valorTotalTributos;
    }

    public NFNotaInfoItemImpostoICMS getIcms() {
        return this.icms;
    }

    public NFNotaInfoItemImpostoIPI getIpi() {
        return this.ipi;
    }

    public NFNotaInfoItemImpostoImportacao getImpostoImportacao() {
        return this.impostoImportacao;
    }

    public NFNotaInfoItemImpostoISSQN getIssqn() {
        return this.issqn;
    }

    public NFNotaInfoItemImpostoPIS getPis() {
        return this.pis;
    }

    public NFNotaInfoItemImpostoPISST getPisst() {
        return this.pisst;
    }

    public NFNotaInfoItemImpostoCOFINS getCofins() {
        return this.cofins;
    }

    public NFNotaInfoItemImpostoCOFINSST getCofinsst() {
        return this.cofinsst;
    }

    public NFNotaInfoItemImpostoICMSUFDestino getIcmsUfDestino() {
        return this.icmsUfDestino;
    }

    public void setIcmsUfDestino(NFNotaInfoItemImpostoICMSUFDestino icmsUfDestino) {
        this.icmsUfDestino = icmsUfDestino;
    }
}

