/*
 * Decompiled with CFR 0.152.
 */
package com.fincatto.documentofiscal.nfe400.classes.nota;

import com.fincatto.documentofiscal.DFBase;
import com.fincatto.documentofiscal.nfe400.classes.NFNotaInfoImpostoTributacaoICMS;
import com.fincatto.documentofiscal.nfe400.classes.NFNotaMotivoReducaoADREM;
import com.fincatto.documentofiscal.nfe400.classes.NFOrigem;
import com.fincatto.documentofiscal.validadores.DFBigDecimalValidador;
import java.math.BigDecimal;
import org.simpleframework.xml.Element;

public class NFNotaInfoItemImpostoICMS15
extends DFBase {
    private static final long serialVersionUID = -941691712925083232L;
    @Element(name="orig")
    private NFOrigem origem;
    @Element(name="CST")
    private NFNotaInfoImpostoTributacaoICMS situacaoTributaria;
    @Element(name="qBCMono", required=false)
    private String quantidadeBaseCalculo;
    @Element(name="adRemICMS")
    private String percentualAliquota;
    @Element(name="vICMSMono")
    private String valorTributo;
    @Element(name="qBCMonoReten", required=false)
    private String quantidadeBaseCalculoTributadaSujeitaRetencao;
    @Element(name="adRemICMSReten")
    private String percentualAliquotaRetencao;
    @Element(name="vICMSMonoReten")
    private String valorTributoRetencao;
    @Element(name="pRedAdRem", required=false)
    private String percentualReducaoAliquota;
    @Element(name="motRedAdRem", required=false)
    private NFNotaMotivoReducaoADREM motivoReducao;

    public void setOrigem(NFOrigem origem) {
        this.origem = origem;
    }

    public void setSituacaoTributaria(NFNotaInfoImpostoTributacaoICMS situacaoTributaria) {
        if (!situacaoTributaria.equals((Object)NFNotaInfoImpostoTributacaoICMS.TRIBUTACAO_MONOFASICA_PROPRIA_E_COM_RESPONSABILIDADE_PELO_RETENCAO_SOBRE_COMBUSTIVES)) {
            throw new IllegalStateException("Situacao tributaria invalida no item ICMS15 ");
        }
        this.situacaoTributaria = situacaoTributaria;
    }

    public void setQuantidadeBaseCalculo(BigDecimal quantidadeBaseCalculo) {
        this.quantidadeBaseCalculo = DFBigDecimalValidador.tamanho15Com2CasasDecimais(quantidadeBaseCalculo, "Quantidade Tributada");
    }

    public void setPercentualAliquota(BigDecimal percentualAliquota) {
        this.percentualAliquota = DFBigDecimalValidador.tamanho7ComAte4CasasDecimais(percentualAliquota, "Al\u00edquota ad rem do imposto");
    }

    public void setValorTributo(BigDecimal valorTributo) {
        this.valorTributo = DFBigDecimalValidador.tamanho15Com2CasasDecimais(valorTributo, "ICMS pr\u00f3prio");
    }

    public void setQuantidadeBaseCalculoTributadaSujeitaRetencao(BigDecimal quantidadeBaseCalculoTributadaSujeitaRetencao) {
        this.quantidadeBaseCalculoTributadaSujeitaRetencao = DFBigDecimalValidador.tamanho15Com2CasasDecimais(quantidadeBaseCalculoTributadaSujeitaRetencao, "Quantidade tributada sujeita a reten\u00e7\u00e3o");
    }

    public void setPercentualAliquotaRetencao(BigDecimal percentualAliquotaRetencao) {
        this.percentualAliquotaRetencao = DFBigDecimalValidador.tamanho7ComAte4CasasDecimais(percentualAliquotaRetencao, "Al\u00edquota ad rem do imposto com reten\u00e7\u00e3o");
    }

    public void setValorTributoRetencao(BigDecimal valorTributoRetencao) {
        this.valorTributoRetencao = DFBigDecimalValidador.tamanho15Com2CasasDecimais(valorTributoRetencao, "ICMS com reten\u00e7\u00e3o");
    }

    public void setPercentualReducaoAliquota(BigDecimal percentualReducaoAliquota) {
        this.percentualReducaoAliquota = DFBigDecimalValidador.tamanho7ComAte4CasasDecimais(percentualReducaoAliquota, "Percentual de redu\u00e7\u00e3o do valor da al\u00edquota adrem do ICMS");
    }

    public void setMotivoReducao(NFNotaMotivoReducaoADREM motivoReducao) {
        this.motivoReducao = motivoReducao;
    }

    public NFOrigem getOrigem() {
        return this.origem;
    }

    public NFNotaInfoImpostoTributacaoICMS getSituacaoTributaria() {
        return this.situacaoTributaria;
    }

    public String getQuantidadeBaseCalculo() {
        return this.quantidadeBaseCalculo;
    }

    public String getPercentualAliquota() {
        return this.percentualAliquota;
    }

    public String getValorTributo() {
        return this.valorTributo;
    }

    public String getQuantidadeBaseCalculoTributadaSujeitaRetencao() {
        return this.quantidadeBaseCalculoTributadaSujeitaRetencao;
    }

    public String getPercentualAliquotaRetencao() {
        return this.percentualAliquotaRetencao;
    }

    public String getValorTributoRetencao() {
        return this.valorTributoRetencao;
    }

    public String getPercentualReducaoAliquota() {
        return this.percentualReducaoAliquota;
    }

    public NFNotaMotivoReducaoADREM getMotivoReducao() {
        return this.motivoReducao;
    }
}

