/*
 * Decompiled with CFR 0.152.
 */
package com.fincatto.documentofiscal.nfe400.classes.nota;

import com.fincatto.documentofiscal.DFBase;
import com.fincatto.documentofiscal.nfe400.classes.NFNotaInfoImpostoTributacaoICMS;
import com.fincatto.documentofiscal.nfe400.classes.NFNotaInfoItemModalidadeBCICMS;
import com.fincatto.documentofiscal.nfe400.classes.NFOrigem;
import com.fincatto.documentofiscal.validadores.DFBigDecimalValidador;
import java.math.BigDecimal;
import org.simpleframework.xml.Element;

public class NFNotaInfoItemImpostoICMS51
extends DFBase {
    private static final long serialVersionUID = -5575047808092974601L;
    @Element(name="orig")
    private NFOrigem origem;
    @Element(name="CST")
    private NFNotaInfoImpostoTributacaoICMS situacaoTributaria;
    @Element(name="modBC", required=false)
    private NFNotaInfoItemModalidadeBCICMS modalidadeBCICMS;
    @Element(name="pRedBC", required=false)
    private String percentualReducaoBC;
    @Element(name="vBC", required=false)
    private String valorBCICMS;
    @Element(name="pICMS", required=false)
    private String percentualICMS;
    @Element(name="vICMSOp", required=false)
    private String valorICMSOperacao;
    @Element(name="pDif", required=false)
    private String percentualDiferimento;
    @Element(name="vICMSDif", required=false)
    private String valorICMSDiferimento;
    @Element(name="vICMS", required=false)
    private String valorICMS;
    @Element(name="vBCFCP", required=false)
    private String valorBCFundoCombatePobreza;
    @Element(name="pFCP", required=false)
    private String percentualFundoCombatePobreza;
    @Element(name="vFCP", required=false)
    private String valorFundoCombatePobreza;
    @Element(name="pFCPDif", required=false)
    private String percentualDiferimentoFundoCombatePobreza;
    @Element(name="vFCPDif", required=false)
    private String valorDiferimentoFundoCombatePobreza;
    @Element(name="vFCPEfet", required=false)
    private String valorEfetivoFundoCombatePobreza;

    public String getPercentualDiferimentoFundoCombatePobreza() {
        return this.percentualDiferimentoFundoCombatePobreza;
    }

    public void setPercentualDiferimentoFundoCombatePobreza(BigDecimal percentualDiferimentoFundoCombatePobreza) {
        if (percentualDiferimentoFundoCombatePobreza.signum() < 0) {
            throw new IllegalStateException("Percentual diferimento fundo de combate a pobreza precisa ser maior que zero!");
        }
        this.percentualDiferimentoFundoCombatePobreza = DFBigDecimalValidador.tamanho7ComAte4CasasDecimais(percentualDiferimentoFundoCombatePobreza, "Percentual diferimento fundo combate pobreza");
    }

    public String getValorDiferimentoFundoCombatePobreza() {
        return this.valorDiferimentoFundoCombatePobreza;
    }

    public void setValorDiferimentoFundoCombatePobreza(BigDecimal valorDiferimentoFundoCombatePobreza) {
        this.valorDiferimentoFundoCombatePobreza = DFBigDecimalValidador.tamanho15Com2CasasDecimais(valorDiferimentoFundoCombatePobreza, "Valor diferimento fundo combate pobreza");
    }

    public String getValorEfetivoFundoCombatePobreza() {
        return this.valorEfetivoFundoCombatePobreza;
    }

    public void setValorEfetivoFundoCombatePobreza(BigDecimal valorEfetivoFundoCombatePobreza) {
        this.valorEfetivoFundoCombatePobreza = DFBigDecimalValidador.tamanho15Com2CasasDecimais(valorEfetivoFundoCombatePobreza, "Valor efetivo fundo combate pobreza");
    }

    public void setOrigem(NFOrigem origem) {
        this.origem = origem;
    }

    public void setSituacaoTributaria(NFNotaInfoImpostoTributacaoICMS situacaoTributaria) {
        this.situacaoTributaria = situacaoTributaria;
    }

    public void setModalidadeBCICMS(NFNotaInfoItemModalidadeBCICMS modalidadeBCICMS) {
        this.modalidadeBCICMS = modalidadeBCICMS;
    }

    public void setPercentualReducaoBC(BigDecimal percentualReducaoBC) {
        this.percentualReducaoBC = DFBigDecimalValidador.tamanho7ComAte4CasasDecimais(percentualReducaoBC, "Percentual Reducao BC ICMS51 Item");
    }

    public void setValorBCICMS(BigDecimal valorBCICMS) {
        this.valorBCICMS = DFBigDecimalValidador.tamanho15Com2CasasDecimais(valorBCICMS, "Valor BC ICMS ICMS51 Item");
    }

    public void setPercentualICMS(BigDecimal percentualICMS) {
        this.percentualICMS = DFBigDecimalValidador.tamanho7ComAte4CasasDecimais(percentualICMS, "Percentual ICMS ICMS51 Item");
    }

    public void setValorICMS(BigDecimal valorICMS) {
        this.valorICMS = DFBigDecimalValidador.tamanho15Com2CasasDecimais(valorICMS, "Valor ICMS ICMS51 Item");
    }

    public void setPercentualDiferimento(BigDecimal percentualDiferimento) {
        this.percentualDiferimento = DFBigDecimalValidador.tamanho7ComAte4CasasDecimais(percentualDiferimento, "Percentual Diferimento ICMS51 Item");
    }

    public void setValorICMSDiferimento(BigDecimal valorICMSDiferimento) {
        this.valorICMSDiferimento = DFBigDecimalValidador.tamanho15Com2CasasDecimais(valorICMSDiferimento, "Valor ICMS Diferimento ICMS51 Item");
    }

    public void setValorICMSOperacao(BigDecimal valorICMSOperacao) {
        this.valorICMSOperacao = DFBigDecimalValidador.tamanho15Com2CasasDecimais(valorICMSOperacao, "Valor ICMS Operacao ICMS51 Item");
    }

    public void setValorBCFundoCombatePobreza(BigDecimal valorBCFundoCombatePobreza) {
        this.valorBCFundoCombatePobreza = DFBigDecimalValidador.tamanho15Com2CasasDecimais(valorBCFundoCombatePobreza, "Valor base calculo fundo combate pobreza");
    }

    public void setPercentualFundoCombatePobreza(BigDecimal percentualFundoCombatePobreza) {
        if (percentualFundoCombatePobreza.signum() < 0) {
            throw new IllegalStateException("Percentual fundo de combate a pobreza precisa ser maior que zero!");
        }
        this.percentualFundoCombatePobreza = DFBigDecimalValidador.tamanho7ComAte4CasasDecimais(percentualFundoCombatePobreza, "Percentual fundo combate pobreza");
    }

    public void setValorFundoCombatePobreza(BigDecimal valorFundoCombatePobreza) {
        this.valorFundoCombatePobreza = DFBigDecimalValidador.tamanho15Com2CasasDecimais(valorFundoCombatePobreza, "Valor fundo combate pobreza");
    }

    public NFOrigem getOrigem() {
        return this.origem;
    }

    public NFNotaInfoImpostoTributacaoICMS getSituacaoTributaria() {
        return this.situacaoTributaria;
    }

    public NFNotaInfoItemModalidadeBCICMS getModalidadeBCICMS() {
        return this.modalidadeBCICMS;
    }

    public String getPercentualReducaoBC() {
        return this.percentualReducaoBC;
    }

    public String getValorBCICMS() {
        return this.valorBCICMS;
    }

    public String getPercentualICMS() {
        return this.percentualICMS;
    }

    public String getValorICMSOperacao() {
        return this.valorICMSOperacao;
    }

    public String getPercentualDiferimento() {
        return this.percentualDiferimento;
    }

    public String getValorICMSDiferimento() {
        return this.valorICMSDiferimento;
    }

    public String getValorICMS() {
        return this.valorICMS;
    }

    public String getValorBCFundoCombatePobreza() {
        return this.valorBCFundoCombatePobreza;
    }

    public String getPercentualFundoCombatePobreza() {
        return this.percentualFundoCombatePobreza;
    }

    public String getValorFundoCombatePobreza() {
        return this.valorFundoCombatePobreza;
    }
}

