/*
 * Decompiled with CFR 0.152.
 */
package com.fincatto.documentofiscal.nfe400.classes.nota;

import com.fincatto.documentofiscal.DFBase;
import com.fincatto.documentofiscal.validadores.DFBigDecimalValidador;
import com.fincatto.documentofiscal.validadores.DFStringValidador;
import java.math.BigDecimal;
import org.simpleframework.xml.Element;

public class NFNotaInfoItemProdutoCombustivelEncerrante
extends DFBase {
    private static final long serialVersionUID = 1807879647248567049L;
    @Element(name="nBico")
    private String numeroBico;
    @Element(name="nBomba", required=false)
    private String numeroBomba;
    @Element(name="nTanque")
    private String numeroTanque;
    @Element(name="vEncIni")
    private String valorEncerramentoInicial;
    @Element(name="vEncFin")
    private String valorEncerramentoFinal;

    public String getNumeroBico() {
        return this.numeroBico;
    }

    public String getNumeroBomba() {
        return this.numeroBomba;
    }

    public String getNumeroTanque() {
        return this.numeroTanque;
    }

    public String getValorEncerramentoInicial() {
        return this.valorEncerramentoInicial;
    }

    public String getValorEncerramentoFinal() {
        return this.valorEncerramentoFinal;
    }

    public void setNumeroBomba(String numeroBomba) {
        DFStringValidador.tamanho3N(numeroBomba, "Numero de identifica\u00e7\u00e3o da bomba ");
        this.numeroBomba = numeroBomba;
    }

    public void setNumeroBico(String numeroBico) {
        DFStringValidador.tamanho3N(numeroBico, "Numero de identifica\u00e7\u00e3o do Bico ");
        this.numeroBico = numeroBico;
    }

    public void setNumeroTanque(String numeroTanque) {
        DFStringValidador.tamanho3N(numeroTanque, "Numero de identifica\u00e7\u00e3o do Tanque ");
        this.numeroTanque = numeroTanque;
    }

    public void setValorEncerramentoInicial(BigDecimal valorEncerramentoInicial) {
        this.valorEncerramentoInicial = DFBigDecimalValidador.tamanho11Com3CasasDecimais(valorEncerramentoInicial, "Valor do Encerrante no inicio do abastecimento");
    }

    public void setValorEncerramentoFinal(BigDecimal valorEncerramentoFinal) {
        this.valorEncerramentoFinal = DFBigDecimalValidador.tamanho11Com3CasasDecimais(valorEncerramentoFinal, "Valor do Encerrante no final do abastecimento");
    }
}

