/*
 * Decompiled with CFR 0.152.
 */
package com.fincatto.documentofiscal.nfe400.classes.nota;

import com.fincatto.documentofiscal.DFBase;
import com.fincatto.documentofiscal.validadores.DFBigDecimalValidador;
import com.fincatto.documentofiscal.validadores.DFStringValidador;
import java.math.BigDecimal;
import org.simpleframework.xml.Element;

public class NFNotaInfoItemProdutoMedicamento
extends DFBase {
    private static final long serialVersionUID = 3127772234811692432L;
    @Element(name="cProdANVISA")
    private String codigoProdutoAnvisa = null;
    @Element(name="xMotivoIsencao", required=false)
    private String motivoIsencao;
    @Element(name="vPMC")
    private String precoMaximoConsumidor = null;

    public String getCodigoProdutoAnvisa() {
        return this.codigoProdutoAnvisa;
    }

    public NFNotaInfoItemProdutoMedicamento setCodigoProdutoAnvisa(String codigoProdutoAnvisa) {
        DFStringValidador.codigoProdutoAnvisa(codigoProdutoAnvisa, "C\u00f3digo produto anvisa");
        this.codigoProdutoAnvisa = codigoProdutoAnvisa;
        return this;
    }

    public String getPrecoMaximoConsumidor() {
        return this.precoMaximoConsumidor;
    }

    public NFNotaInfoItemProdutoMedicamento setPrecoMaximoConsumidor(BigDecimal precoMaximoConsumidor) {
        this.precoMaximoConsumidor = DFBigDecimalValidador.tamanho15Com2CasasDecimais(precoMaximoConsumidor, "Pre\u00e7o m\u00e1ximo consumidor");
        return this;
    }

    public String getMotivoIsencao() {
        return this.motivoIsencao;
    }

    public NFNotaInfoItemProdutoMedicamento setMotivoIsencao(String motivoIsencao) {
        DFStringValidador.validaTamanhoMaximo(motivoIsencao, 255, "Motivo da isen\u00e7\u00e3o da ANVISA");
        this.motivoIsencao = motivoIsencao;
        return this;
    }
}

