/*
 * Decompiled with CFR 0.152.
 */
package com.fincatto.documentofiscal.nfe400.classes.nota;

import com.fincatto.documentofiscal.DFBase;
import com.fincatto.documentofiscal.nfe400.classes.NFModalidadeFrete;
import com.fincatto.documentofiscal.nfe400.classes.nota.NFNotaInfoReboque;
import com.fincatto.documentofiscal.nfe400.classes.nota.NFNotaInfoRetencaoICMSTransporte;
import com.fincatto.documentofiscal.nfe400.classes.nota.NFNotaInfoTransportador;
import com.fincatto.documentofiscal.nfe400.classes.nota.NFNotaInfoVeiculo;
import com.fincatto.documentofiscal.nfe400.classes.nota.NFNotaInfoVolume;
import com.fincatto.documentofiscal.validadores.DFListValidador;
import com.fincatto.documentofiscal.validadores.DFStringValidador;
import java.util.List;
import org.simpleframework.xml.Element;
import org.simpleframework.xml.ElementList;

public class NFNotaInfoTransporte
extends DFBase {
    private static final long serialVersionUID = 1172316192774549031L;
    @Element(name="modFrete")
    private NFModalidadeFrete modalidadeFrete;
    @Element(name="transporta", required=false)
    private NFNotaInfoTransportador transportador;
    @Element(name="retTransp", required=false)
    private NFNotaInfoRetencaoICMSTransporte icmsTransporte;
    @Element(name="veicTransp", required=false)
    private NFNotaInfoVeiculo veiculo;
    @ElementList(entry="reboque", inline=true, required=false)
    private List<NFNotaInfoReboque> reboques;
    @Element(name="vagao", required=false)
    private String vagao;
    @Element(name="balsa", required=false)
    private String balsa;
    @ElementList(entry="vol", inline=true, required=false)
    private List<NFNotaInfoVolume> volumes;

    public void setModalidadeFrete(NFModalidadeFrete modalidadeFrete) {
        this.modalidadeFrete = modalidadeFrete;
    }

    public void setTransportador(NFNotaInfoTransportador transportador) {
        this.transportador = transportador;
    }

    public void setIcmsTransporte(NFNotaInfoRetencaoICMSTransporte icmsTransporte) {
        this.icmsTransporte = icmsTransporte;
    }

    public void setVeiculo(NFNotaInfoVeiculo veiculo) {
        this.veiculo = veiculo;
    }

    public void setReboques(List<NFNotaInfoReboque> reboques) {
        DFListValidador.tamanho5(reboques, "Reboques");
        this.reboques = reboques;
    }

    public void setVolumes(List<NFNotaInfoVolume> volumes) {
        DFListValidador.tamanho5000(volumes, "Volumes");
        this.volumes = volumes;
    }

    public void setVagao(String vagao) {
        DFStringValidador.tamanho20(vagao, "Vagao");
        this.vagao = vagao;
    }

    public void setBalsa(String balsa) {
        DFStringValidador.tamanho20(balsa, "Balsa");
        this.balsa = balsa;
    }

    public NFModalidadeFrete getModalidadeFrete() {
        return this.modalidadeFrete;
    }

    public NFNotaInfoTransportador getTransportador() {
        return this.transportador;
    }

    public NFNotaInfoRetencaoICMSTransporte getIcmsTransporte() {
        return this.icmsTransporte;
    }

    public NFNotaInfoVeiculo getVeiculo() {
        return this.veiculo;
    }

    public List<NFNotaInfoReboque> getReboques() {
        return this.reboques;
    }

    public String getVagao() {
        return this.vagao;
    }

    public String getBalsa() {
        return this.balsa;
    }

    public List<NFNotaInfoVolume> getVolumes() {
        return this.volumes;
    }
}

