/*
 * Decompiled with CFR 0.152.
 */
package com.fincatto.documentofiscal.nfe400.classes.nota;

public enum NFOperadoraCartao {
    VISA("01", "Visa"),
    MASTERCARD("02", "Mastercard"),
    AMERICAN_EXPRESS("03", "American Express"),
    SOROCRED("04", "Sorocred"),
    DINERS_CLUB("05", "Diners Club"),
    ELO("06", "Elo"),
    HIPERCARD("07", "Hibercard"),
    AURA("08", "Aura"),
    CABAL("09", "Cabal"),
    OUTROS("99", "Outros");

    private String codigo;
    private String descricao;

    private NFOperadoraCartao(String codigo, String descricao) {
        this.codigo = codigo;
        this.descricao = descricao;
    }

    public String getCodigo() {
        return this.codigo;
    }

    public static NFOperadoraCartao valueOfCodigo(String codigo) {
        for (NFOperadoraCartao operadora : NFOperadoraCartao.values()) {
            if (!operadora.getCodigo().equals(codigo)) continue;
            return operadora;
        }
        return null;
    }

    public String toString() {
        return this.codigo + " - " + this.descricao;
    }

    public String getDescricao() {
        return this.descricao;
    }

    public void setDescricao(String descricao) {
        this.descricao = descricao;
    }

    public void setCodigo(String codigo) {
        this.codigo = codigo;
    }
}

