/*
 * Decompiled with CFR 0.152.
 */
package com.fincatto.documentofiscal.nfe400.utils;

import com.fincatto.documentofiscal.nfe.NFeConfig;
import com.fincatto.documentofiscal.nfe400.classes.nota.NFNota;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Base64;

public class NFGeraHashCSRT {
    private final String chaveAcesso;
    private final NFeConfig config;

    public NFGeraHashCSRT(String chaveAcesso, NFeConfig config) {
        this.chaveAcesso = chaveAcesso;
        this.config = config;
    }

    public NFGeraHashCSRT(NFNota nota, NFeConfig config) {
        this.chaveAcesso = nota.getInfo().getChaveAcesso();
        this.config = config;
    }

    public String getHashCSRT() throws NoSuchAlgorithmException {
        return NFGeraHashCSRT.base64EncodeToString(this.config.getCSRT() + this.chaveAcesso);
    }

    public static String base64EncodeToString(String toEncode) throws NoSuchAlgorithmException {
        return Base64.getEncoder().encodeToString(NFGeraHashCSRT.getSha1(toEncode));
    }

    public static byte[] getSha1(String toEncode) throws NoSuchAlgorithmException {
        return MessageDigest.getInstance("SHA1").digest(toEncode.getBytes());
    }

    public static String getStringSha1(String toEncode) throws NoSuchAlgorithmException {
        return String.format("%040x", new BigInteger(1, NFGeraHashCSRT.getSha1(toEncode)));
    }
}

