/*
 * Decompiled with CFR 0.152.
 */
package com.fincatto.documentofiscal.nfe400.utils.qrcode20;

import com.fincatto.documentofiscal.DFAmbiente;
import com.fincatto.documentofiscal.nfe.NFeConfig;
import com.fincatto.documentofiscal.nfe400.classes.nota.NFNota;
import java.math.BigInteger;
import java.nio.charset.Charset;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.apache.commons.lang3.StringUtils;

public abstract class NFGeraQRCode20 {
    public static final String VERSAO_QRCODE = "2";
    protected final NFNota nota;
    protected final NFeConfig config;

    public NFGeraQRCode20(NFNota nota, NFeConfig config) {
        this.nota = nota;
        this.config = config;
    }

    public abstract String getQRCode() throws NoSuchAlgorithmException;

    public String getUrlQRCode() {
        String url;
        String string = url = this.config.getAmbiente().equals((Object)DFAmbiente.PRODUCAO) ? this.nota.getInfo().getIdentificacao().getUf().getQrCodeProducao() : this.nota.getInfo().getIdentificacao().getUf().getQrCodeHomologacao();
        if (StringUtils.isBlank((CharSequence)url)) {
            throw new IllegalArgumentException("URL para consulta do QRCode nao informada para uf " + (Object)((Object)this.nota.getInfo().getIdentificacao().getUf()) + "!");
        }
        if (StringUtils.isBlank((CharSequence)this.config.getCodigoSegurancaContribuinte())) {
            throw new IllegalArgumentException("CSC nao informado nas configuracoes!");
        }
        if (this.config.getCodigoSegurancaContribuinteID() == null || this.config.getCodigoSegurancaContribuinteID() == 0) {
            throw new IllegalArgumentException("IdCSC nao informado nas configuracoes!");
        }
        return url;
    }

    public static String createHash(String campos, String csc) throws NoSuchAlgorithmException {
        return NFGeraQRCode20.sha1(campos + csc);
    }

    public static String toHex(String arg) {
        return String.format("%040x", new BigInteger(1, arg.getBytes(Charset.forName("UTF-8"))));
    }

    public static String sha1(String input) throws NoSuchAlgorithmException {
        StringBuilder sb = new StringBuilder();
        for (byte element : MessageDigest.getInstance("SHA1").digest(input.getBytes(Charset.forName("UTF-8")))) {
            sb.append(Integer.toString((element & 0xFF) + 256, 16).substring(1));
        }
        return sb.toString().toUpperCase();
    }

    public String urlConsultaChaveAcesso() {
        return this.config.getAmbiente().equals((Object)DFAmbiente.PRODUCAO) ? this.nota.getInfo().getIdentificacao().getUf().getConsultaChaveAcessoProducao() : this.nota.getInfo().getIdentificacao().getUf().getConsultaChaveAcessoHomologacao();
    }
}

