/*
 * Decompiled with CFR 0.152.
 */
package com.fincatto.documentofiscal.nfe400.utils.qrcode20;

import com.fincatto.documentofiscal.nfe.NFeConfig;
import com.fincatto.documentofiscal.nfe400.classes.nota.NFNota;
import com.fincatto.documentofiscal.nfe400.utils.qrcode20.NFGeraQRCode20;
import java.security.NoSuchAlgorithmException;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;

public class NFGeraQRCodeContingenciaOffline20
extends NFGeraQRCode20 {
    public NFGeraQRCodeContingenciaOffline20(NFNota nota, NFeConfig config) {
        super(nota, config);
    }

    @Override
    public String getQRCode() throws NoSuchAlgorithmException {
        String url = this.getUrlQRCode();
        ZonedDateTime dt = this.nota.getInfo().getIdentificacao().getDataHoraEmissao();
        String diaEmissao = DateTimeFormatter.ofPattern("dd").format(dt);
        StringBuilder parametros = new StringBuilder();
        parametros.append(this.nota.getInfo().getChaveAcesso()).append("|");
        parametros.append("2").append("|");
        parametros.append(this.config.getAmbiente().getCodigo()).append("|");
        parametros.append(diaEmissao).append("|");
        parametros.append(this.nota.getInfo().getTotal().getIcmsTotal().getValorTotalNFe()).append("|");
        parametros.append(NFGeraQRCodeContingenciaOffline20.toHex(this.nota.getAssinatura().getSignedInfo().getReference().getDigestValue())).append("|");
        parametros.append(this.config.getCodigoSegurancaContribuinteID());
        return url + "?p=" + parametros.toString() + "|" + NFGeraQRCodeContingenciaOffline20.createHash(parametros.toString(), this.config.getCodigoSegurancaContribuinte());
    }
}

