/*
 * Decompiled with CFR 0.152.
 */
package com.fincatto.documentofiscal.nfe400.utils.qrcode30;

import com.fincatto.documentofiscal.DFAmbiente;
import com.fincatto.documentofiscal.nfe.NFeConfig;
import com.fincatto.documentofiscal.nfe400.classes.nota.NFNota;
import com.fincatto.documentofiscal.utils.DFAssinaturaDigital;
import org.apache.commons.lang3.StringUtils;

public abstract class NFGeraQRCode30 {
    public static final String VERSAO_QRCODE = "3";
    protected final NFNota nota;
    protected final NFeConfig config;

    public NFGeraQRCode30(NFNota nota, NFeConfig config) {
        this.nota = nota;
        this.config = config;
    }

    public abstract String getQRCode() throws Exception;

    public String getUrlQRCode() {
        String url;
        String string = url = this.config.getAmbiente().equals((Object)DFAmbiente.PRODUCAO) ? this.nota.getInfo().getIdentificacao().getUf().getQrCodeProducao() : this.nota.getInfo().getIdentificacao().getUf().getQrCodeHomologacao();
        if (StringUtils.isBlank((CharSequence)url)) {
            throw new IllegalArgumentException("URL para consulta do QRCode nao informada para uf " + (Object)((Object)this.nota.getInfo().getIdentificacao().getUf()) + "!");
        }
        return url;
    }

    public String assinar(String parametros) throws Exception {
        return new DFAssinaturaDigital(this.config).assinarString(parametros);
    }

    public String urlConsultaChaveAcesso() {
        return this.config.getAmbiente().equals((Object)DFAmbiente.PRODUCAO) ? this.nota.getInfo().getIdentificacao().getUf().getConsultaChaveAcessoProducao() : this.nota.getInfo().getIdentificacao().getUf().getConsultaChaveAcessoHomologacao();
    }
}

