/*
 * Decompiled with CFR 0.152.
 */
package com.fincatto.documentofiscal.nfe400.utils.qrcode30;

import com.fincatto.documentofiscal.nfe.NFeConfig;
import com.fincatto.documentofiscal.nfe400.classes.nota.NFNota;
import com.fincatto.documentofiscal.nfe400.utils.qrcode30.NFGeraQRCode30;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;

public class NFGeraQRCodeContingenciaOffline30
extends NFGeraQRCode30 {
    public NFGeraQRCodeContingenciaOffline30(NFNota nota, NFeConfig config) {
        super(nota, config);
    }

    @Override
    public String getQRCode() throws Exception {
        String url = this.getUrlQRCode();
        ZonedDateTime dt = this.nota.getInfo().getIdentificacao().getDataHoraEmissao();
        String diaEmissao = DateTimeFormatter.ofPattern("dd").format(dt);
        String tpIdDest = "";
        String idDest = "";
        if (this.nota.getInfo().getDestinatario() != null) {
            if (this.nota.getInfo().getDestinatario().getCnpj() != null) {
                tpIdDest = "1";
                idDest = this.nota.getInfo().getDestinatario().getCnpj();
            } else if (this.nota.getInfo().getDestinatario().getCpf() != null) {
                tpIdDest = "2";
                idDest = this.nota.getInfo().getDestinatario().getCpf();
            } else if (this.nota.getInfo().getDestinatario().getIdEstrangeiro() != null) {
                tpIdDest = "3";
            }
        }
        StringBuilder parametros = new StringBuilder();
        parametros.append(this.nota.getInfo().getChaveAcesso()).append("|");
        parametros.append("3").append("|");
        parametros.append(this.config.getAmbiente().getCodigo()).append("|");
        parametros.append(diaEmissao).append("|");
        parametros.append(this.nota.getInfo().getTotal().getIcmsTotal().getValorTotalNFe()).append("|");
        parametros.append(tpIdDest).append("|");
        parametros.append(idDest);
        return url + "?p=" + parametros.toString() + "|" + this.assinar(parametros.toString());
    }
}

