/*
 * Decompiled with CFR 0.152.
 */
package com.fincatto.documentofiscal.nfe400.webservices;

import com.fincatto.documentofiscal.DFLog;
import com.fincatto.documentofiscal.DFModelo;
import com.fincatto.documentofiscal.nfe.NFeConfig;
import com.fincatto.documentofiscal.nfe400.NotaFiscalChaveParser;
import com.fincatto.documentofiscal.nfe400.classes.NFAutorizador400;
import com.fincatto.documentofiscal.nfe400.classes.evento.NFEnviaEventoRetorno;
import com.fincatto.documentofiscal.nfe400.classes.evento.cancelamento.NFEnviaEventoCancelamento;
import com.fincatto.documentofiscal.nfe400.classes.evento.cancelamento.NFEventoCancelamento;
import com.fincatto.documentofiscal.nfe400.classes.evento.cancelamento.NFInfoCancelamento;
import com.fincatto.documentofiscal.nfe400.classes.evento.cancelamento.NFInfoEventoCancelamento;
import com.fincatto.documentofiscal.nfe400.webservices.gerado.NFeRecepcaoEvento4Stub;
import com.fincatto.documentofiscal.utils.DFAssinaturaDigital;
import java.math.BigDecimal;
import java.time.ZonedDateTime;
import java.util.Collections;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.util.AXIOMUtil;

class WSCancelamento
implements DFLog {
    private static final BigDecimal VERSAO_LEIAUTE = new BigDecimal("1.00");
    private static final String DESCRICAO_EVENTO = "Cancelamento";
    private static final String EVENTO_CANCELAMENTO = "110111";
    private static final String DESCRICAO_EVENTO_CANCELAMENTO_POR_SUBSTITUICAO = "Cancelamento por substituicao";
    private static final String EVENTO_CANCELAMENTO_POR_SUBSTITUICAO = "110112";
    private final NFeConfig config;

    WSCancelamento(NFeConfig config) {
        this.config = config;
    }

    NFEnviaEventoRetorno cancelaNotaAssinada(String chaveAcesso, String eventoAssinadoXml) throws Exception {
        OMElement omElementResult = this.efetuaCancelamento(eventoAssinadoXml, chaveAcesso);
        return (NFEnviaEventoRetorno)this.config.getPersister().read(NFEnviaEventoRetorno.class, omElementResult.toString());
    }

    NFEnviaEventoRetorno cancelaNota(String chaveAcesso, String numeroProtocolo, String motivo) throws Exception {
        String cancelamentoNotaXML = this.gerarDadosCancelamento(chaveAcesso, numeroProtocolo, motivo).toString();
        String xmlAssinado = new DFAssinaturaDigital(this.config).assinarDocumento(cancelamentoNotaXML);
        OMElement omElementResult = this.efetuaCancelamento(xmlAssinado, chaveAcesso);
        return (NFEnviaEventoRetorno)this.config.getPersister().read(NFEnviaEventoRetorno.class, omElementResult.toString());
    }

    private OMElement efetuaCancelamento(String xmlAssinado, String chaveAcesso) throws Exception {
        String urlWebService;
        NFeRecepcaoEvento4Stub.NfeDadosMsg dados = new NFeRecepcaoEvento4Stub.NfeDadosMsg();
        OMElement omElementXML = AXIOMUtil.stringToOM((String)xmlAssinado);
        this.getLogger().debug(omElementXML.toString());
        dados.setExtraElement(omElementXML);
        NotaFiscalChaveParser parser = new NotaFiscalChaveParser(chaveAcesso);
        NFAutorizador400 autorizador = NFAutorizador400.valueOfChaveAcesso(chaveAcesso);
        String string = urlWebService = DFModelo.NFCE.equals((Object)parser.getModelo()) ? autorizador.getNfceRecepcaoEvento(this.config.getAmbiente()) : autorizador.getRecepcaoEvento(this.config.getAmbiente());
        if (urlWebService == null) {
            throw new IllegalArgumentException("Nao foi possivel encontrar URL para RecepcaoEvento " + parser.getModelo().name() + ", autorizador " + autorizador.name());
        }
        NFeRecepcaoEvento4Stub.NfeResultMsg nfeRecepcaoEvento = new NFeRecepcaoEvento4Stub(urlWebService, this.config).nfeRecepcaoEvento(dados);
        OMElement omElementResult = nfeRecepcaoEvento.getExtraElement();
        this.getLogger().debug(omElementResult.toString());
        return omElementResult;
    }

    private NFEnviaEventoCancelamento gerarDadosCancelamento(String chaveAcesso, String numeroProtocolo, String motivo) {
        NotaFiscalChaveParser chaveParser = new NotaFiscalChaveParser(chaveAcesso);
        NFInfoCancelamento cancelamento = new NFInfoCancelamento();
        cancelamento.setDescricaoEvento(DESCRICAO_EVENTO);
        cancelamento.setVersao(VERSAO_LEIAUTE);
        cancelamento.setJustificativa(motivo);
        cancelamento.setProtocoloAutorizacao(numeroProtocolo);
        NFInfoEventoCancelamento infoEvento = new NFInfoEventoCancelamento();
        infoEvento.setAmbiente(this.config.getAmbiente());
        infoEvento.setChave(chaveAcesso);
        if (Integer.parseInt(chaveParser.getSerie()) >= 920 && Integer.parseInt(chaveParser.getSerie()) <= 969 && chaveParser.isEmitentePessoaFisica()) {
            infoEvento.setCpf(chaveParser.getCpfEmitente());
        } else {
            infoEvento.setCnpj(chaveParser.getCnpjEmitente());
        }
        infoEvento.setDataHoraEvento(ZonedDateTime.now(this.config.getTimeZone().toZoneId()));
        infoEvento.setId(String.format("ID%s%s0%s", EVENTO_CANCELAMENTO, chaveAcesso, "1"));
        infoEvento.setNumeroSequencialEvento(1);
        infoEvento.setOrgao(chaveParser.getNFUnidadeFederativa());
        infoEvento.setCodigoEvento(EVENTO_CANCELAMENTO);
        infoEvento.setVersaoEvento(VERSAO_LEIAUTE);
        infoEvento.setCancelamento(cancelamento);
        NFEventoCancelamento evento = new NFEventoCancelamento();
        evento.setInfoEvento(infoEvento);
        evento.setVersao(VERSAO_LEIAUTE);
        NFEnviaEventoCancelamento enviaEvento = new NFEnviaEventoCancelamento();
        enviaEvento.setEvento(Collections.singletonList(evento));
        enviaEvento.setIdLote(Long.toString(ZonedDateTime.now(this.config.getTimeZone().toZoneId()).toInstant().toEpochMilli()));
        enviaEvento.setVersao(VERSAO_LEIAUTE);
        return enviaEvento;
    }

    NFEnviaEventoRetorno cancelaNotaPorSubstituicao(String chaveAcesso, String numeroProtocolo, String motivo, String versaoAplicativoAutorizador, String chaveSubstituta) throws Exception {
        String cancelamentoNotaXML = this.gerarDadosCancelamentoPorSubstituicao(chaveAcesso, numeroProtocolo, motivo, versaoAplicativoAutorizador, chaveSubstituta).toString();
        String xmlAssinado = new DFAssinaturaDigital(this.config).assinarDocumento(cancelamentoNotaXML);
        OMElement omElementResult = this.efetuaCancelamento(xmlAssinado, chaveAcesso);
        return (NFEnviaEventoRetorno)this.config.getPersister().read(NFEnviaEventoRetorno.class, omElementResult.toString());
    }

    private NFEnviaEventoCancelamento gerarDadosCancelamentoPorSubstituicao(String chaveAcesso, String numeroProtocolo, String motivo, String versaoAplicativoAutorizador, String chaveSubstituta) {
        NotaFiscalChaveParser chaveParser = new NotaFiscalChaveParser(chaveAcesso);
        if (DFModelo.NFE.equals((Object)chaveParser.getModelo())) {
            throw new IllegalArgumentException("Evento nao permitido para modelo 55 - NFe!");
        }
        NFInfoCancelamento cancelamento = new NFInfoCancelamento();
        cancelamento.setDescricaoEvento(DESCRICAO_EVENTO_CANCELAMENTO_POR_SUBSTITUICAO);
        cancelamento.setUfAutorizador(chaveParser.getNFUnidadeFederativa());
        cancelamento.setTipoAutorizador("1");
        cancelamento.setVersaoAplicativo(versaoAplicativoAutorizador);
        cancelamento.setVersao(VERSAO_LEIAUTE);
        cancelamento.setJustificativa(motivo);
        cancelamento.setProtocoloAutorizacao(numeroProtocolo);
        cancelamento.setChaveAcessoSubstituta(chaveSubstituta);
        NFInfoEventoCancelamento infoEvento = new NFInfoEventoCancelamento();
        infoEvento.setAmbiente(this.config.getAmbiente());
        infoEvento.setChave(chaveAcesso);
        if (Integer.parseInt(chaveParser.getSerie()) >= 920 && Integer.parseInt(chaveParser.getSerie()) <= 969) {
            infoEvento.setCpf(chaveParser.getCpfEmitente());
        } else {
            infoEvento.setCnpj(chaveParser.getCnpjEmitente());
        }
        infoEvento.setDataHoraEvento(ZonedDateTime.now(this.config.getTimeZone().toZoneId()));
        infoEvento.setId(String.format("ID%s%s0%s", EVENTO_CANCELAMENTO_POR_SUBSTITUICAO, chaveAcesso, "1"));
        infoEvento.setNumeroSequencialEvento(1);
        infoEvento.setOrgao(chaveParser.getNFUnidadeFederativa());
        infoEvento.setCodigoEvento(EVENTO_CANCELAMENTO_POR_SUBSTITUICAO);
        infoEvento.setVersaoEvento(VERSAO_LEIAUTE);
        infoEvento.setCancelamento(cancelamento);
        NFEventoCancelamento evento = new NFEventoCancelamento();
        evento.setInfoEvento(infoEvento);
        evento.setVersao(VERSAO_LEIAUTE);
        NFEnviaEventoCancelamento enviaEvento = new NFEnviaEventoCancelamento();
        enviaEvento.setEvento(Collections.singletonList(evento));
        enviaEvento.setIdLote(Long.toString(ZonedDateTime.now(this.config.getTimeZone().toZoneId()).toInstant().toEpochMilli()));
        enviaEvento.setVersao(VERSAO_LEIAUTE);
        return enviaEvento;
    }
}

