/*
 * Decompiled with CFR 0.152.
 */
package com.fincatto.documentofiscal.nfe400.webservices;

import com.fincatto.documentofiscal.DFLog;
import com.fincatto.documentofiscal.DFModelo;
import com.fincatto.documentofiscal.nfe.NFeConfig;
import com.fincatto.documentofiscal.nfe400.NotaFiscalChaveParser;
import com.fincatto.documentofiscal.nfe400.classes.NFAutorizador400;
import com.fincatto.documentofiscal.nfe400.classes.evento.NFEnviaEventoRetorno;
import com.fincatto.documentofiscal.nfe400.classes.evento.NFEvento;
import com.fincatto.documentofiscal.nfe400.classes.evento.NFInfoEvento;
import com.fincatto.documentofiscal.nfe400.classes.evento.NFTipoEvento;
import com.fincatto.documentofiscal.nfe400.classes.evento.cartacorrecao.NFEnviaEventoCartaCorrecao;
import com.fincatto.documentofiscal.nfe400.classes.evento.cartacorrecao.NFProtocoloEventoCartaCorrecao;
import com.fincatto.documentofiscal.nfe400.webservices.gerado.NFeRecepcaoEvento4Stub;
import com.fincatto.documentofiscal.utils.DFAssinaturaDigital;
import java.math.BigDecimal;
import java.rmi.RemoteException;
import java.time.ZonedDateTime;
import java.util.Collections;
import javax.xml.stream.XMLStreamException;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.util.AXIOMUtil;

class WSCartaCorrecao
implements DFLog {
    private static final BigDecimal VERSAO_LEIAUTE = new BigDecimal("1.00");
    private static final String EVENTO_CODIGO = "110110";
    private static final String EVENTO_DESCRICAO = "Carta de Correcao";
    private static final String EVENTO_CONDICAO_USO = "A Carta de Correcao e disciplinada pelo paragrafo 1o-A do art. 7o do Convenio S/N, de 15 de dezembro de 1970 e pode ser utilizada para regularizacao de erro ocorrido na emissao de documento fiscal, desde que o erro nao esteja relacionado com: I - as variaveis que determinam o valor do imposto tais como: base de calculo, aliquota, diferenca de preco, quantidade, valor da operacao ou da prestacao; II - a correcao de dados cadastrais que implique mudanca do remetente ou do destinatario; III - a data de emissao ou de saida.";
    private final NFeConfig config;

    WSCartaCorrecao(NFeConfig config) {
        this.config = config;
    }

    NFEnviaEventoRetorno corrigeNota(String chaveAcesso, String textoCorrecao, int numeroSequencialEvento) throws Exception {
        String xmlAssinado = this.getXmlAssinado(chaveAcesso, textoCorrecao, numeroSequencialEvento);
        OMElement omElementResult = this.efetuaCorrecao(xmlAssinado, chaveAcesso);
        return (NFEnviaEventoRetorno)this.config.getPersister().read(NFEnviaEventoRetorno.class, omElementResult.toString());
    }

    NFEnviaEventoRetorno corrigeNotaAssinada(String xmlAssinado) throws Exception {
        NFEnviaEventoCartaCorrecao enviaEventoCartaCorrecao = (NFEnviaEventoCartaCorrecao)this.config.getPersister().read(NFEnviaEventoCartaCorrecao.class, xmlAssinado);
        OMElement omElementResult = this.efetuaCorrecao(xmlAssinado, enviaEventoCartaCorrecao.getEvento().get(0).getInfoEvento().getChave());
        return (NFEnviaEventoRetorno)this.config.getPersister().read(NFEnviaEventoRetorno.class, omElementResult.toString());
    }

    NFProtocoloEventoCartaCorrecao corrigeNotaAssinadaProtocolo(String xmlAssinado) throws Exception {
        NFEnviaEventoCartaCorrecao evento = (NFEnviaEventoCartaCorrecao)this.config.getPersister().read(NFEnviaEventoCartaCorrecao.class, xmlAssinado);
        OMElement omElementResult = this.efetuaCorrecao(xmlAssinado, evento.getEvento().get(0).getInfoEvento().getChave());
        NFEnviaEventoRetorno retorno = (NFEnviaEventoRetorno)this.config.getPersister().read(NFEnviaEventoRetorno.class, omElementResult.toString());
        NFProtocoloEventoCartaCorrecao nfProtocoloEventoCartaCorrecao = new NFProtocoloEventoCartaCorrecao();
        nfProtocoloEventoCartaCorrecao.setEvento(evento.getEvento().get(0));
        nfProtocoloEventoCartaCorrecao.setEventoRetorno(retorno.getEventoRetorno().get(0));
        return nfProtocoloEventoCartaCorrecao;
    }

    NFEnviaEventoRetorno corrigeNotaAssinada(String chaveAcesso, String eventoAssinadoXml) throws Exception {
        OMElement omElementResult = this.efetuaCorrecao(eventoAssinadoXml, chaveAcesso);
        return (NFEnviaEventoRetorno)this.config.getPersister().read(NFEnviaEventoRetorno.class, omElementResult.toString());
    }

    private OMElement efetuaCorrecao(String xmlAssinado, String chaveAcesso) throws XMLStreamException, RemoteException {
        String urlWebService;
        NFeRecepcaoEvento4Stub.NfeDadosMsg dados = new NFeRecepcaoEvento4Stub.NfeDadosMsg();
        OMElement omElementXML = AXIOMUtil.stringToOM((String)xmlAssinado);
        this.getLogger().debug(omElementXML.toString());
        dados.setExtraElement(omElementXML);
        NotaFiscalChaveParser parser = new NotaFiscalChaveParser(chaveAcesso);
        NFAutorizador400 autorizacao = NFAutorizador400.valueOfCodigoUF(this.config.getCUF());
        String string = urlWebService = DFModelo.NFCE.equals((Object)parser.getModelo()) ? autorizacao.getNfceRecepcaoEvento(this.config.getAmbiente()) : autorizacao.getRecepcaoEvento(this.config.getAmbiente());
        if (urlWebService == null) {
            throw new IllegalArgumentException("Nao foi possivel encontrar URL para RecepcaoEvento " + parser.getModelo().name() + ", autorizador " + autorizacao.name());
        }
        NFeRecepcaoEvento4Stub.NfeResultMsg nfeRecepcaoEvento = new NFeRecepcaoEvento4Stub(urlWebService, this.config).nfeRecepcaoEvento(dados);
        OMElement omElementResult = nfeRecepcaoEvento.getExtraElement();
        this.getLogger().debug(omElementResult.toString());
        return omElementResult;
    }

    public String getXmlAssinado(String chaveAcesso, String textoCorrecao, int numeroSequencialEvento) throws Exception {
        String cartaCorrecaoXML = this.gerarDadosCartaCorrecao(chaveAcesso, textoCorrecao, numeroSequencialEvento).toString();
        return new DFAssinaturaDigital(this.config).assinarDocumento(cartaCorrecaoXML);
    }

    public NFEnviaEventoCartaCorrecao gerarDadosCartaCorrecao(String chaveAcesso, String textoCorrecao, int numeroSequencialEvento) {
        NotaFiscalChaveParser chaveParser = new NotaFiscalChaveParser(chaveAcesso);
        NFTipoEvento cartaCorrecao = new NFTipoEvento();
        cartaCorrecao.setVersao(VERSAO_LEIAUTE);
        cartaCorrecao.setDescricaoEvento(EVENTO_DESCRICAO);
        cartaCorrecao.setCondicaoUso(EVENTO_CONDICAO_USO);
        cartaCorrecao.setTextoCorrecao(textoCorrecao);
        NFInfoEvento infoEvento = new NFInfoEvento();
        infoEvento.setAmbiente(this.config.getAmbiente());
        infoEvento.setDadosEvento(cartaCorrecao);
        infoEvento.setChave(chaveAcesso);
        if (Integer.parseInt(chaveParser.getSerie()) >= 920 && Integer.parseInt(chaveParser.getSerie()) <= 969) {
            infoEvento.setCpf(chaveParser.getCpfEmitente());
        } else {
            infoEvento.setCnpj(chaveParser.getCnpjEmitente());
        }
        infoEvento.setDataHoraEvento(ZonedDateTime.now(this.config.getTimeZone().toZoneId()));
        infoEvento.setId(String.format("ID%s%s%02d", EVENTO_CODIGO, chaveAcesso, numeroSequencialEvento));
        infoEvento.setNumeroSequencialEvento(numeroSequencialEvento);
        infoEvento.setOrgao(chaveParser.getNFUnidadeFederativa());
        infoEvento.setTipoEvento(EVENTO_CODIGO);
        infoEvento.setVersaoEvento(VERSAO_LEIAUTE);
        NFEvento evento = new NFEvento();
        evento.setInfoEvento(infoEvento);
        evento.setVersao(VERSAO_LEIAUTE);
        NFEnviaEventoCartaCorrecao enviaEvento = new NFEnviaEventoCartaCorrecao();
        enviaEvento.setEvento(Collections.singletonList(evento));
        enviaEvento.setIdLote(Long.toString(ZonedDateTime.now(this.config.getTimeZone().toZoneId()).toInstant().toEpochMilli()));
        enviaEvento.setVersao(VERSAO_LEIAUTE);
        return enviaEvento;
    }
}

