/*
 * Decompiled with CFR 0.152.
 */
package com.fincatto.documentofiscal.nfe400.webservices;

import com.fincatto.documentofiscal.DFLog;
import com.fincatto.documentofiscal.DFUnidadeFederativa;
import com.fincatto.documentofiscal.nfe.NFeConfig;
import com.fincatto.documentofiscal.nfe400.classes.NFAutorizador400;
import com.fincatto.documentofiscal.nfe400.classes.cadastro.NFConsultaCadastro;
import com.fincatto.documentofiscal.nfe400.classes.cadastro.NFInfoConsultaCadastro;
import com.fincatto.documentofiscal.nfe400.classes.cadastro.NFRetornoConsultaCadastro;
import com.fincatto.documentofiscal.nfe400.webservices.consultacadastro.CadConsultaCadastro4Stub;
import com.fincatto.documentofiscal.nfe400.webservices.consultacadastro.MTCadConsultaCadastro4Stub;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.util.AXIOMUtil;

class WSConsultaCadastro
implements DFLog {
    private static final String NOME_SERVICO = "CONS-CAD";
    private static final String VERSAO_SERVICO = "2.00";
    private final NFeConfig config;

    WSConsultaCadastro(NFeConfig config) {
        this.config = config;
    }

    NFRetornoConsultaCadastro consultaCadastro(String cnpj, DFUnidadeFederativa uf) throws Exception {
        NFConsultaCadastro dadosConsulta = this.getDadosConsulta(cnpj, uf);
        String xmlConsulta = dadosConsulta.toString();
        this.getLogger().debug(xmlConsulta);
        OMElement omElementConsulta = AXIOMUtil.stringToOM((String)xmlConsulta);
        OMElement resultado = this.efetuaConsulta(uf, omElementConsulta);
        this.getLogger().debug(resultado.toString());
        return (NFRetornoConsultaCadastro)this.config.getPersister().read(NFRetornoConsultaCadastro.class, resultado.toString());
    }

    NFRetornoConsultaCadastro consultaCadastroInscEst(String inscEst, DFUnidadeFederativa uf) throws Exception {
        NFConsultaCadastro dadosConsulta = this.getDadosConsultaInscEst(inscEst, uf);
        String xmlConsulta = dadosConsulta.toString();
        this.getLogger().debug(xmlConsulta);
        OMElement omElementConsulta = AXIOMUtil.stringToOM((String)xmlConsulta);
        OMElement resultado = this.efetuaConsulta(uf, omElementConsulta);
        this.getLogger().debug(resultado.toString());
        return (NFRetornoConsultaCadastro)this.config.getPersister().read(NFRetornoConsultaCadastro.class, resultado.toString());
    }

    private OMElement efetuaConsulta(DFUnidadeFederativa uf, OMElement omElementConsulta) throws Exception {
        NFAutorizador400 autorizador = NFAutorizador400.valueOfCodigoUF(uf);
        String urlConsulta = autorizador.getConsultaCadastro(this.config.getAmbiente());
        if (urlConsulta == null) {
            throw new IllegalStateException(String.format("UF %s nao possui autorizador para este servico", uf.getDescricao()));
        }
        if (DFUnidadeFederativa.MT.equals((Object)uf)) {
            MTCadConsultaCadastro4Stub.ConsultaCadastro consultaCadastro = new MTCadConsultaCadastro4Stub.ConsultaCadastro();
            MTCadConsultaCadastro4Stub.NfeDadosMsg_type0 dadosMsg = new MTCadConsultaCadastro4Stub.NfeDadosMsg_type0();
            dadosMsg.setExtraElement(omElementConsulta);
            consultaCadastro.setNfeDadosMsg(dadosMsg);
            return new MTCadConsultaCadastro4Stub(urlConsulta).consultaCadastro(consultaCadastro).getConsultaCadastroResult().getExtraElement();
        }
        CadConsultaCadastro4Stub.NfeDadosMsg nfeDadosMsg_type0 = new CadConsultaCadastro4Stub.NfeDadosMsg();
        nfeDadosMsg_type0.setExtraElement(omElementConsulta);
        return new CadConsultaCadastro4Stub(urlConsulta, this.config).consultaCadastro(nfeDadosMsg_type0).getExtraElement();
    }

    private NFConsultaCadastro getDadosConsulta(String cnpj, DFUnidadeFederativa uf) {
        NFConsultaCadastro consulta = new NFConsultaCadastro();
        consulta.setVersao(VERSAO_SERVICO);
        consulta.setConsultaCadastro(new NFInfoConsultaCadastro());
        consulta.getConsultaCadastro().setCnpj(cnpj);
        consulta.getConsultaCadastro().setServico(NOME_SERVICO);
        consulta.getConsultaCadastro().setUf(uf.getCodigo());
        return consulta;
    }

    private NFConsultaCadastro getDadosConsultaInscEst(String inscEst, DFUnidadeFederativa uf) {
        NFConsultaCadastro consulta = new NFConsultaCadastro();
        consulta.setVersao(VERSAO_SERVICO);
        consulta.setConsultaCadastro(new NFInfoConsultaCadastro());
        consulta.getConsultaCadastro().setInscricaoEstadual(inscEst);
        consulta.getConsultaCadastro().setServico(NOME_SERVICO);
        consulta.getConsultaCadastro().setUf(uf.getCodigo());
        return consulta;
    }
}

