/*
 * Decompiled with CFR 0.152.
 */
package com.fincatto.documentofiscal.nfe400.webservices;

import com.fincatto.documentofiscal.DFLog;
import com.fincatto.documentofiscal.DFModelo;
import com.fincatto.documentofiscal.DFUnidadeFederativa;
import com.fincatto.documentofiscal.nfe.NFTipoEmissao;
import com.fincatto.documentofiscal.nfe.NFeConfig;
import com.fincatto.documentofiscal.nfe400.classes.NFAutorizador400;
import com.fincatto.documentofiscal.nfe400.classes.evento.epec.NFDestinatarioEpec;
import com.fincatto.documentofiscal.nfe400.classes.evento.epec.NFEnviaEventoEpec;
import com.fincatto.documentofiscal.nfe400.classes.evento.epec.NFEnviaEventoEpecRetorno;
import com.fincatto.documentofiscal.nfe400.classes.evento.epec.NFEventoEpec;
import com.fincatto.documentofiscal.nfe400.classes.evento.epec.NFInfoEpec;
import com.fincatto.documentofiscal.nfe400.classes.evento.epec.NFInfoEventoEpec;
import com.fincatto.documentofiscal.nfe400.classes.lote.envio.NFLoteEnvio;
import com.fincatto.documentofiscal.nfe400.classes.nota.NFNota;
import com.fincatto.documentofiscal.nfe400.utils.NFGeraChave;
import com.fincatto.documentofiscal.nfe400.webservices.gerado.NFeRecepcaoEvento4Stub;
import com.fincatto.documentofiscal.utils.DFAssinaturaDigital;
import com.fincatto.documentofiscal.validadores.DFXMLValidador;
import java.io.StringReader;
import java.math.BigDecimal;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.impl.builder.StAXOMBuilder;
import org.apache.commons.lang3.StringUtils;

public class WSEpec
implements DFLog {
    private static final BigDecimal VERSAO_LEIAUTE = new BigDecimal("1.00");
    public static final String TIPO_EVENTO_EPEC = "110140";
    public static final String DESCRICAO_EVENTO_EPEC = "EPEC";
    private static final String NFE_ELEMENTO = "NFe";
    private final NFeConfig config;

    public WSEpec(NFeConfig config) {
        this.config = config;
    }

    NFEnviaEventoEpecRetorno enviaEpecAssinado(String epecAssinadoXml) throws Exception {
        return this.comunicaEpec(epecAssinadoXml);
    }

    NFEnviaEventoEpecRetorno enviaEpec(NFLoteEnvio loteEnvio) throws Exception {
        NFEnviaEventoEpec epec = this.criaEnvioEpec(loteEnvio);
        int nSeqEvento = 1;
        for (NFEventoEpec eventoEpec : epec.getEvento()) {
            NFNota nota = eventoEpec.getNota();
            NFGeraChave geraChave = new NFGeraChave(nota);
            String chave = geraChave.getChaveAcesso();
            eventoEpec.getInfoEvento().setIdentificador("ID110140" + chave + (nSeqEvento < 10 ? "0" + nSeqEvento : Integer.valueOf(nSeqEvento)));
            eventoEpec.getInfoEvento().setNumeroSequencialEvento(nSeqEvento++);
            eventoEpec.getInfoEvento().setChave(chave);
        }
        String documentoAssinado = new DFAssinaturaDigital(this.config).assinarDocumento(epec.toString());
        NFEnviaEventoEpec epecAssinado = (NFEnviaEventoEpec)this.config.getPersister().read(NFEnviaEventoEpec.class, documentoAssinado);
        NFEnviaEventoEpecRetorno epecEnvioRetorno = this.comunicaEpec(epecAssinado.toString());
        return epecEnvioRetorno;
    }

    private NFEnviaEventoEpec criaEnvioEpec(NFLoteEnvio loteEnvio) {
        NFEnviaEventoEpec nfEnviaEventoEpec = new NFEnviaEventoEpec();
        nfEnviaEventoEpec.setIdLote(StringUtils.isBlank((CharSequence)loteEnvio.getIdLote()) ? String.valueOf(new Date().getTime()) : loteEnvio.getIdLote());
        nfEnviaEventoEpec.setVersao("1.00");
        nfEnviaEventoEpec.setEvento(new ArrayList<NFEventoEpec>());
        int i = 1;
        for (NFNota nfNota : loteEnvio.getNotas()) {
            NFEventoEpec nfEventoEpec = new NFEventoEpec();
            nfEventoEpec.setNota(nfNota);
            nfNota.getInfo().getIdentificacao().setTipoEmissao(NFTipoEmissao.CONTINGENCIA_EPEC);
            nfEventoEpec.setVersao("1.00");
            NFInfoEventoEpec infEpec = new NFInfoEventoEpec();
            infEpec.setAmbiente(this.config.getAmbiente());
            if (StringUtils.isNotBlank((CharSequence)nfNota.getInfo().getEmitente().getCnpj())) {
                infEpec.setCnpj(nfNota.getInfo().getEmitente().getCnpj());
            } else {
                infEpec.setCpf(nfNota.getInfo().getEmitente().getCpf());
            }
            infEpec.setCodigoEvento(TIPO_EVENTO_EPEC);
            infEpec.setNumeroSequencialEvento(i++);
            infEpec.setOrgao(DFUnidadeFederativa.RFB);
            infEpec.setVersaoEvento("1.00");
            infEpec.setDataHoraEvento(ZonedDateTime.now(this.config.getTimeZone().toZoneId()));
            NFInfoEpec nfInfoEpec = new NFInfoEpec();
            nfInfoEpec.setDataHoraEmissao(ZonedDateTime.ofInstant(nfNota.getInfo().getIdentificacao().getDataHoraEmissao().toInstant(), ZoneId.systemDefault()));
            nfInfoEpec.setDescricaoEvento(DESCRICAO_EVENTO_EPEC);
            nfInfoEpec.setInscricaoEstadualEmitente(nfNota.getInfo().getEmitente().getInscricaoEstadual());
            nfInfoEpec.setOrgaoAutor(DFUnidadeFederativa.valueOfCodigo(nfNota.getInfo().getEmitente().getEndereco().getUf()).getCodigoIbge());
            nfInfoEpec.setTipoNota("1");
            nfInfoEpec.setTpAutor("1");
            nfInfoEpec.setVersao(VERSAO_LEIAUTE);
            nfInfoEpec.setVersaoAplicativo("1.0");
            infEpec.setEpec(nfInfoEpec);
            if (nfNota.getInfo().getDestinatario() != null) {
                NFDestinatarioEpec nfDestinatarioEpec = new NFDestinatarioEpec();
                if (StringUtils.isNotBlank((CharSequence)nfNota.getInfo().getDestinatario().getCnpj())) {
                    nfDestinatarioEpec.setCnpj(nfNota.getInfo().getDestinatario().getCnpj());
                } else {
                    nfDestinatarioEpec.setCpf(nfNota.getInfo().getDestinatario().getCpfj());
                }
                nfDestinatarioEpec.setIdEstrangeiro(nfNota.getInfo().getDestinatario().getIdEstrangeiro());
                nfDestinatarioEpec.setInscricaoEstadualDestinatario(nfNota.getInfo().getDestinatario().getInscricaoEstadual());
                if (nfNota.getInfo().getDestinatario().getEndereco() != null) {
                    nfDestinatarioEpec.setUfDestinatario(nfNota.getInfo().getDestinatario().getEndereco().getUf());
                }
                if (nfNota.getInfo().getTotal() != null) {
                    nfDestinatarioEpec.setValorTotalIcms(nfNota.getInfo().getTotal().getIcmsTotal().getValorTotalICMS());
                    nfDestinatarioEpec.setValorTotalIcmsSubstituicaoTributaria(nfNota.getInfo().getTotal().getIcmsTotal().getValorTotalICMSST());
                    nfDestinatarioEpec.setValorTotalNFe(nfNota.getInfo().getTotal().getIcmsTotal().getValorTotalNFe());
                }
                nfInfoEpec.setDestinatario(nfDestinatarioEpec);
            }
            nfEventoEpec.setInfoEvento(infEpec);
            nfEnviaEventoEpec.getEvento().add(nfEventoEpec);
        }
        return nfEnviaEventoEpec;
    }

    private NFEnviaEventoEpecRetorno comunicaEpec(String epecAssinadoXml) throws Exception {
        NFeRecepcaoEvento4Stub.NfeResultMsg recepcaoLoteResult = this.comunicaLoteRaw(epecAssinadoXml, DFModelo.NFE);
        OMElement omElementResult = recepcaoLoteResult.getExtraElement();
        String xmlRetorno = omElementResult.toString();
        return (NFEnviaEventoEpecRetorno)this.config.getPersister().read(NFEnviaEventoEpecRetorno.class, xmlRetorno);
    }

    public NFeRecepcaoEvento4Stub.NfeResultMsg comunicaLoteRaw(String loteAssinadoXml, DFModelo modelo) throws Exception {
        String endpoint;
        DFXMLValidador.validaEpec(loteAssinadoXml);
        OMElement omElement = this.nfeToOMElement(loteAssinadoXml);
        NFeRecepcaoEvento4Stub.NfeDadosMsg dados = new NFeRecepcaoEvento4Stub.NfeDadosMsg();
        dados.setExtraElement(omElement);
        NFAutorizador400 autorizador = NFAutorizador400.valueOfTipoEmissao(this.config.getTipoEmissao(), this.config.getCUF());
        String string = endpoint = DFModelo.NFE.equals((Object)modelo) ? autorizador.getRecepcaoEvento(this.config.getAmbiente()) : autorizador.getNfceAutorizacao(this.config.getAmbiente());
        if (endpoint == null) {
            throw new IllegalArgumentException("Nao foi possivel encontrar URL para Autorizacao " + modelo.name() + ", autorizador " + autorizador.name());
        }
        return new NFeRecepcaoEvento4Stub(endpoint, this.config).nfeRecepcaoEvento(dados);
    }

    private OMElement nfeToOMElement(String documento) throws XMLStreamException {
        XMLInputFactory factory = XMLInputFactory.newInstance();
        factory.setProperty("javax.xml.stream.isCoalescing", false);
        XMLStreamReader reader = factory.createXMLStreamReader(new StringReader(documento));
        StAXOMBuilder builder = new StAXOMBuilder(reader);
        OMElement ome = builder.getDocumentElement();
        Iterator children = ome.getChildrenWithLocalName(NFE_ELEMENTO);
        while (children.hasNext()) {
            OMElement omElement = (OMElement)children.next();
            if (omElement == null || !NFE_ELEMENTO.equals(omElement.getLocalName())) continue;
            omElement.addAttribute("xmlns", "http://www.portalfiscal.inf.br/nfe", null);
        }
        return ome;
    }
}

